% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thingsboard_api.R
\docType{class}
\name{ThingsboardApi-class}
\alias{ThingsboardApi-class}
\alias{ThingsboardApi}
\title{Thingboard API Class}
\description{
Thingboard API Class
}
\section{Fields}{

\describe{
\item{\code{url}}{\link{character} URL of the 'ThingsBoard' IoT platform.}

\item{\code{publicId}}{\link{character} the public ID of the device}

\item{\code{token}}{\link{character} the current token}

\item{\code{tokenTimeOut}}{A \link{numeric} contains the time out of a token in seconds (default 300)}

\item{\code{tokenEpiration}}{A \link{numeric} with the Epoch of the expiration date time of current token}
}}


\examples{
\donttest{
thinksboard_api = tryCatch(
  {
    ThingsboardApi(url="http://scada.g-eau.fr",
                   publicId="299cedc0-f3e9-11e8-9dbf-cbc1e37c11e3")
  },
  error = function(e) {
    message("An error occured:\n", e)
    return(FALSE)
  }
)
}
}
\seealso{
The \code{ThingsboardApi} class methods :
\itemize{
\item \link{ThingsboardApi_checkToken} for checking and refreshing the token
\item \link{ThingsboardApi_getToken} for getting authorisation token from Thingsboard server for a specific device
\item \link{ThingsboardApi_getKeys} for fetching data keys of an entity
\item \link{ThingsboardApi_getValues} and \link{ThingsboardApi_getTelemetry} for fetching telemetry of an entity
}
}
