% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{CalculateLimits}
\alias{CalculateLimits}
\title{CalculateLimits}
\usage{
CalculateLimits(x, lcl = NA, cl = NA, ucl = NA, type = "i",
  controlLimitDistance = 3)
}
\arguments{
\item{x}{Numerical vector}

\item{lcl}{Lower control limit, single value or NA}

\item{cl}{Central line, single value or NA}

\item{ucl}{Upper control limit, single value or NA}

\item{type}{Type of control chart, either "i" for i-chart (default) or "c" for c-chart}

\item{controlLimitDistance}{Multiple of st.dev to be used to calculate limits, possible values: 1, 2, 3 (default); this parameter affect the interpretation of lcl and ucl parameters}
}
\value{
Named list with limits
}
\description{
Evaluates whether to use custom limits or calculate them from the data.
}
\details{
If at least two limits were provided, the missing ones are calculated from the them. If one or zero limits were provided the rest is computed from data.
}
\examples{
CalculateLimits(x = rnorm(10), lcl = NA, cl = 100, ucl = NA, type = 'i')
}
