% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2d.R
\name{plotpcs}
\alias{plotpcs}
\title{Plot in polar coordinate system}
\usage{
plotpcs(theta, a, ab = 1, orig = c(0, 0), fun = graphics::plot, ...)
}
\arguments{
\item{theta}{Angle in polar coordinate system}

\item{a}{Radius of start and end points of the arrow.}

\item{ab}{Semi-major over semi-minor. ab=1 for a Ring.}

\item{orig}{Origin}

\item{fun}{Plot function. default = plot}

\item{...}{More options in plot function}
}
\description{
Plot in polar coordinate system
}
\examples{

n=50
par(mfrow=c(2,1))
plotpcs(theta = 1:n * 15, a=1:n/10, ab=1, type='l', asp=1)
plotpcs(theta = 1:n * 10, a=1:n/10, ab=1, type='l', asp=1)
xy = PCS2CCS(theta = 1:n * 10, a=1:n/10, ab=1)
xy[,1]=xy[,1]+1
points(xy, pch=19, col=terrain.colors(nrow(xy)))

}
