% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psiFuns.R
\name{rhoprime2}
\alias{rhoprime2}
\title{The second derivative of the rho function}
\usage{
rhoprime2(u, family, cc, standardize = FALSE)
}
\arguments{
\item{u}{point or vector at which rho is to be evaluated}

\item{family}{family string specifying the name of the family of loss function to be used (current valid
options are "bisquare", "opt" and "mopt").}

\item{cc}{tuning parameters to be computed according to efficiency and / or breakdown
considerations. See \link{lmrobdet.control}, \link{bisquare}, \link{mopt}
and \link{opt}.}

\item{standardize}{logical value determining whether the rho function is to be
standardized so that its maximum value is 1. See \code{Mpsi}.}
}
\value{
The value of the second derivative of \code{rho} evaluated at \code{u}
}
\description{
The second derivative of the rho function
}
\examples{
# Evaluate the 2nd derivative of a rho function tuned for 85\% efficiency
rhoprime2(u=1.1, family='bisquare', cc=bisquare(.85))
# Evaluate the 2nd derivative of a rho function tuned for 50\% breakdown
rhoprime2(u=1.1, family='opt', cc=lmrobdet.control(bb=.5, family='opt')$tuning.chi)

}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
