% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenizers.R
\name{token_morph}
\alias{token_morph}
\alias{token_words}
\alias{token_nouns}
\title{Morpheme tokenizer based on mecab-ko}
\usage{
token_morph(phrase, strip_punct = FALSE, strip_numeric = FALSE)

token_words(phrase, strip_punct = FALSE, strip_numeric = FALSE)

token_nouns(phrase, strip_punct = FALSE, strip_numeric = FALSE)
}
\arguments{
\item{phrase}{A character vector or a list of character vectors to be tokenized into morphemes.
If \code{phrase} is a charactor vector, it can be of any length, and each element
will be tokenized separately. If \code{phrase} is a list of charactor vectors, each element
of the list should be a one-item vector.}

\item{strip_punct}{Bool. If you want to remove punctuations in the phrase, set this as TRUE.}

\item{strip_numeric}{Bool. If you want to remove numbers in the phrase, set this as TRUE.}
}
\value{
A list of character vectors containing the tokens, with one element in the list.

See examples in \href{https://github.com/junhewk/RmecabKo}{Github}.
}
\description{
These tokernizer functions perform tokenization into full or selected morphemes,
nouns.
}
\examples{
\dontrun{
txt <- # Some Korean sentence

token_morph(txt)
token_words(txt, strip_punct = FALSE)
token_nouns(txt, strip_numeric = TRUE)
}

}
