% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_spd_geometry.R
\name{spd.geometry}
\alias{spd.geometry}
\title{Supported Geometries on SPD Manifold}
\usage{
spd.geometry(geometry)
}
\arguments{
\item{geometry}{name of supported geometries, including
\describe{
\item{AIRM}{Affine-Invariant Riemannian Metric.}
\item{LERM}{Log-Euclidean Riemannian Metric.}
\item{Jeffrey}{Jeffrey's divergence.}
\item{Stein}{Stein's metric.}
\item{Wasserstein}{2-Wasserstein geometry.}
}}
}
\value{
a matching name in lower-case.
}
\description{
SPD manifold is a well-studied space in that there have been many geometries 
proposed on the space. For special functions on under SPD category, this 
function finds whether there exists a matching name that is currently 
supported in \pkg{Riemann}. If there is none, it will return an error message.
}
\examples{
# it just returns a small-letter string.
mygeom = spd.geometry("stein")

}
\concept{spd}
