% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_passiflora.R
\docType{data}
\name{passiflora}
\alias{passiflora}
\title{Data : Passiflora Leaves}
\format{
a named list containing\describe{
\item{data}{a 3d array of size \eqn{(15\times 2\times 3319)}.}
\item{species}{a length-\eqn{3319} vector of 40 species factors.}
\item{class}{a length-\eqn{3319} vector of 7 cluster factors.}
}
}
\usage{
data(passiflora)
}
\description{
Passiflora is a genus of about 550 species of flowering plants. This dataset contains 
15 landmarks in 2 dimension of 3319 leaves of 40 species. Papers listed in the 
reference section analyzed the data and found 7 clusters.
}
\examples{
data(passiflora)                         # load the data
riemobj = wrap.landmark(passiflora$data) # wrap as RIEMOBJ
pga2d   = riem.pga(riemobj)$embed        # embedding via PGA

opar <- par(no.readonly=TRUE)            # visualize
plot(pga2d, col=passiflora$class, pch=19, cex=0.7,
     main="PGA Embedding of Passiflora Leaves",
     xlab="dimension 1", ylab="dimension 2")
par(opar)

}
\references{
\insertRef{chitwood_divergent_2017}{Riemann}

\insertRef{chitwood_morphometric_2017}{Riemann}
}
\seealso{
\code{\link{wrap.landmark}}
}
\concept{data}
\keyword{datasets}
