% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_fuzzy_system}
\alias{predict_fuzzy_system}
\title{predict the outcome of a fuzzy system on some input data}
\usage{
predict_fuzzy_system(fs, x, verbose = FALSE)
}
\arguments{
\item{fs}{the fuzzy system to predict on (as a named list)}

\item{x}{the input data to use with the fuzzy system to predict the output}

\item{verbose}{whether to be verbose}
}
\value{
the predicted output data as a data frame
}
\description{
predict the outcome of a fuzzy system on some input data
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
x <- mtcars[c("mpg", "hp", "wt")]
y <- mtcars["qsec"]
fit <- fit_xy(model, x, y, progress = FALSE)

y2 <- predict_fuzzy_system(fit$fuzzy_system,x)
}
