% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_hybrid.R
\name{fuzzycoco_fit_df_hybrid}
\alias{fuzzycoco_fit_df_hybrid}
\title{lowest-level implementation of the fitting of a fuzzy coco model using the \strong{hybrid engine}}
\usage{
fuzzycoco_fit_df_hybrid(
  model,
  x,
  y,
  until = stop_engine_on_first_of(max_generations =
    model$params$global_params$max_generations, max_fitness =
    model$params$global_params$max_fitness),
  verbose = model$verbose,
  progress = TRUE
)
}
\arguments{
\item{model}{a Fuzzy Coco model as a \code{fuzzy_coco} object}

\item{x}{the input variables data (usually to fit) as a dataframe}

\item{y}{the output variables data (usually to fit)  as a dataframe}

\item{until}{function that takes an \code{engine} and returns TRUE if and only if the evolution must stop.
It is a way for the user to customize the stop conditions of the algorithm.}

\item{verbose}{whether to be verbose}

\item{progress}{whether to display the computation progress (using progressr, if available)}
}
\value{
a named list as a \code{fuzzy_coco} fit object
}
\description{
lowest-level implementation of the fitting of a fuzzy coco model using the \strong{hybrid engine}
}
\examples{
 model <- fuzzycoco("regression", example_mtcars()$params)
 fit <- fuzzycoco_fit_df_hybrid(model, mtcars[c("mpg", "hp", "wt")],  mtcars["qsec"])
}
