% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup}
\alias{setup}
\alias{setupOff}
\title{Setup a project library, cache, options}
\usage{
setup(
  newLibPaths,
  RPackageFolders,
  RPackageCache = cacheGetOptionCachePkgDir(),
  standAlone = getOption("Require.standAlone", TRUE),
  verbose = getOption("Require.verbose")
)

setupOff(removePackages = FALSE, verbose = getOption("Require.verbose"))
}
\arguments{
\item{newLibPaths}{Same as \code{RPackageFolders}. This is for more consistent
naming with \code{Require(..., libPaths = ...)}.}

\item{RPackageFolders}{One or more folders where R packages are
installed to and loaded from. In the case of more than one
folder provided, installation will only happen in the first one.}

\item{RPackageCache}{See \code{?RequireOptions}.}

\item{standAlone}{Logical. If \code{TRUE}, all packages will be installed to and
loaded from the \code{libPaths} only. NOTE: If \code{TRUE}, THIS WILL CHANGE THE
USER'S \code{.libPaths()}, similar to e.g., the \code{checkpoint} package. If
\code{FALSE}, then \code{libPath} will be prepended to \code{.libPaths()} during the
\code{Require} call, resulting in shared packages, i.e., it will include the
user's default package folder(s). This can be create dramatically faster
installs if the user has a substantial number of the packages already in
their personal library. Default \code{FALSE} to minimize package installing.}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, also returns details as if
\code{returnDetails = TRUE} (for backwards compatibility).}

\item{removePackages}{Deprecated. Please remove packages manually from
the .libPaths()}
}
\description{
\code{setup} and \code{setupOff} are currently deprecated.
These may be re-created in a future version.
In its place, a user can simply put \code{.libPaths(libs, include.site = FALSE)}
in their \code{.Rprofile} file, where \code{libs} is the directory where the packages
should be installed and should be a folder with the R version number, e.g.,
derived by using \code{checkLibPaths(libs)}.
}
