% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Require2.R
\name{availablePackagesOverride}
\alias{availablePackagesOverride}
\title{Create a custom "available.packages" object}
\usage{
availablePackagesOverride(
  toInstall,
  repos,
  purge,
  type = getOption("pkgType"),
  verbose = getOption("Require.verbose")
)
}
\arguments{
\item{toInstall}{A \code{pkgDT} object}

\item{repos}{The remote repository (e.g., a CRAN mirror), passed to either
\code{install.packages}, \code{install_github} or \code{installVersions}.}

\item{purge}{Logical. Should all caches be purged? Default is
\code{getOption("Require.purge", FALSE)}. There is a lot of internal caching of
results throughout the \code{Require} package. These help with speed and reduce
calls to internet sources. However, sometimes these caches must be purged.
The cached values are renewed when found to be too old, with the age limit.
This maximum age can be set in seconds with the environment variable
\code{R_AVAILABLE_PACKAGES_CACHE_CONTROL_MAX_AGE}, or if unset, defaults to 3600
(one hour -- see \code{\link[utils:available.packages]{utils::available.packages}}).

Internally, there are calls to \code{available.packages}.}

\item{type}{See \code{utils::install.packages}}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, also returns details as if
\code{returnDetails = TRUE} (for backwards compatibility).}
}
\description{
This is the mechanism by which \code{install.packages} determines which packages
should be installed from where. With this override, we can indicate arbitrary
\code{repos}, \code{Package}, \code{File} for each individual package.
}
