% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pEdgington.R
\name{pEdgington}
\alias{pEdgington}
\title{Computes Edgington's p-value}
\usage{
pEdgington(zo = NULL, zr = NULL, po = NULL, pr = NULL, r = 1)
}
\arguments{
\item{zo}{A vector of z-values from original studies.}

\item{zr}{A vector of z-values from replication studies.}

\item{po}{A vector of one-sided original p-values.}

\item{pr}{A vector of one-sided replication p-values.}

\item{r}{Numeric vector of ratios of replication to original weight}
}
\value{
Edgington's p-value
}
\description{
The combined p-value with Edgington's method is
computed based on the one-sided p-values (or the corresponding the z-values)
of the original and replication study, and the ratio of the
weight of the replication study over the weight of the
original study
}
\details{
Either \code{zo} and \code{zr}, or \code{po} and \code{pr}, must be
    specified.
}
\examples{
## examples from paper
pEdgington(po = 0.026, pr = 0.001)
pEdgington(po = 0.024, pr = 0.024)

## using z-values
pEdgington(zo = 1.91, zr = 1.95)
## using combination of z-value and p-value
pEdgington(zo = 1.91, pr = 0.024)
}
\references{
Held, L., Pawel, S., Micheloud, C. (2024). The assessment of
    replicability using the sum of p-values. \emph{Royal Society Open
    Science}. 11(8):11240149. \doi{10.1098/rsos.240149}
}
\author{
Charlotte Micheloud, Leonhard Held, Samuel Pawel
}
