\name{env}
\alias{env}
\title{Fit the response envelope model}
\description{
 Fit the response envelope model in multivariate linear regression with dimension u. 
}
\usage{
env(X, Y, u, asy = TRUE, init = NULL)
}
\arguments{
  \item{X}{Predictors. An n by p matrix, p is the number of predictors. The predictors can be univariate or multivariate, discrete or continuous.}
  \item{Y}{Multivariate responses. An n by r matrix, r is the number of responses and n is number of observations. The responses must be continuous variables.}
  \item{u}{Dimension of the envelope. An integer between 0 and r.}
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{init}{The user-specified value of Gamma for the envelope subspace. An r by u matrix. The default is the one generated by function envMU.}
}
\details{
 This function fits the envelope model to the responses and predictors, \deqn{
 Y = \mu + \Gamma\eta X+\varepsilon, \Sigma=\Gamma\Omega\Gamma'+\Gamma_{0}\Omega_{0}\Gamma'_{0}
 }
 using the maximum likelihood estimation.  When the dimension of the envelope is between 1 and r-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is r, then the envelope model degenerates to the standard multivariate linear regression.  When the dimension is 0, it means that X and Y are uncorrelated, and the fitting is different.
}
\value{The output is a list that contains the following components:
\item{beta}{The envelope estimator of the regression coefficients.} 
\item{Sigma}{The envelope estimator of the error covariance matrix.}
\item{Gamma}{An orthonormal basis of the envelope subspace.}
\item{Gamma0}{An orthonormal basis of the complement of the envelope subspace.}
\item{eta}{The coordinates of beta with respect to Gamma.}
\item{Omega}{The coordinates of Sigma with respect to Gamma.}
\item{Omega0}{The coordinates of Sigma with respect to Gamma0.}
\item{mu}{The estimated intercept.}
\item{loglik}{The maximized log likelihood function.}
\item{covMatrix}{The asymptotic covariance of vec(beta). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.}
\item{asySE}{The asymptotic standard error for elements in beta under the envelope model.  The standard errors returned are asymptotic, for actual standard errors, multiply by 1 / sqrt(n).}
\item{ratio}{The asymptotic standard error ratio of the standard multivariate linear regression estimator over the envelope estimator, for each element in beta.}
\item{n}{The number of observations in the data.}
}
\references{
Cook, R. D., Li, B. and Chiaromente, F. (2010). Envelope Models for Parsimonious and Efficient Multivariate Linear Regression (with discussion). Statist. Sinica 20, 927- 1010.

Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
data(wheatprotein)
X <- wheatprotein[, 8]
Y <- wheatprotein[, 1:6]
u <- u.env(X, Y)
u

m <- env(X, Y, 1)
m
m$beta
}

