% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.startOW.R
\name{param.startOW}
\alias{param.startOW}
\title{Initial values extraction for Odd Weibull distribution}
\usage{
param.startOW(param, initValOW)
}
\arguments{
\item{param}{a character used to specify the parameter required. It can take the
values \code{"sigma"} or \code{"nu"}.}

\item{initValOW}{an \code{initValOW} object generated with \code{\link{initValuesOW}}
function.}
}
\value{
A length-one vector numeric value corresponding to the initial value of the
parameter specified in \code{param} extracted from a \code{\link{initValuesOW}} 
object specified in the \code{initValOW} input argument.
}
\description{
This function can be used to extract initial values found with empirical 
time on test transform (TTT) through  \code{\link{initValuesOW}} function. 
This is used for parameter estimation in \code{OW} distribution.
}
\details{
This function just gets initial values computed with \code{\link{initValuesOW}} 
for \code{OW} family. It must be called in \code{sigma.start} and \code{nu.start} 
arguments from \code{\link[gamlss]{gamlss}} function. This function is useful only
if user want to set start values automatically with TTT plot.
See example for an illustration.
}
\examples{
# Random data generation (OW distributed)
y <- rOW(n=500, mu=0.05, sigma=0.6, nu=2)

# Initial values with TTT plot
iv <- initValuesOW(formula = y ~ 1)
summary(iv)

# This data is from unimodal hazard
# See TTT estimate from sample
plot(iv, legend_options=list(pos=1.03))

# See the true hazard
curve(hOW(x, mu=0.05, sigma=0.6, nu=2), to=100, lwd=3, ylab="h(x)")

# Finally, we fit the model
require(gamlss)
con.out <- gamlss.control(n.cyc = 300, trace = FALSE)
con.in <- glim.control(cyc = 300)

(sigma.start <- param.startOW("sigma", iv))
(nu.start <- param.startOW("nu", iv))

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, control=con.out, i.control=con.in,
              family=myOW_region(OW(sigma.link="identity", nu.link="identity"),
                                 valid.values="auto", iv),
              sigma.start=sigma.start, nu.start=nu.start)

# Estimates are close to actual values
(mu <- exp(coef(mod, what = "mu")))
(sigma <- coef(mod, what = "sigma"))
(nu <- coef(mod, what = "nu"))
  
}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
