% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCS2e.R
\name{dCS2e}
\alias{dCS2e}
\alias{pCS2e}
\alias{qCS2e}
\alias{rCS2e}
\alias{hCS2e}
\title{The Cosine Sine Exponential distribution}
\usage{
dCS2e(x, mu, sigma, nu, log = FALSE)

pCS2e(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qCS2e(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rCS2e(n, mu, sigma, nu)

hCS2e(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{nu}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dCS2e} gives the density, \code{pCS2e} gives the distribution 
function, \code{qCS2e} gives the quantile function, \code{rCS2e}
generates random deviates and \code{hCS2e} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Cosine Sine Exponential distribution 
with parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The Cosine Sine Exponential Distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x)=\frac{\pi \sigma \mu \exp(\frac{-x} {\nu})}{2 \nu [(\mu\sin(\frac{\pi}{2} \exp(\frac{-x} {\nu})) + \sigma\cos(\frac{\pi}{2} \exp(\frac{-x} {\nu}))]^2}, }

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{\nu > 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
par(mfrow=c(1,1))
curve(dCS2e(x, mu=1, sigma=0.1, nu =0.1), from=0, to=1,
      ylim=c(0, 3), col="red", las=1, ylab="f(x)")
      
## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pCS2e(x, mu=1, sigma=0.1, nu =0.1),
      from=0, to=1,  col="red", las=1, ylab="F(x)")
curve(pCS2e(x, mu=1, sigma=0.1, nu =0.1, lower.tail=FALSE),
      from=0, to=1, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qCS2e(p, mu=0.1, sigma=1, nu=0.1), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pCS2e(x, mu=0.1, sigma=1, nu=0.1), from=0, add=TRUE, col="red")

## The random function
hist(rCS2e(n=10000, mu=0.1, sigma=1, nu=0.1), freq=FALSE,
     xlab="x", las=1, main="")
curve(dCS2e(x, mu=0.1, sigma=1, nu=0.1), from=0, add=TRUE, col="red")

## The Hazard function
par(mfrow=c(1,1))
curve(hCS2e(x, mu=1, sigma=0.1, nu =0.1), from=0, to=1, ylim=c(0, 10),
      col=2, ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{chesneau2018new}{RelDists}
}
\author{
Juan Pablo Ramirez
}
