% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RW.R
\name{RW}
\alias{RW}
\title{The Reflected Weibull family}
\usage{
RW(mu.link = "log", sigma.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}
}
\value{
Returns a gamlss.family object which can be used to fit a RW distribution in the \code{gamlss()} function.
}
\description{
Reflected Weibull distribution
}
\details{
The Reflected Weibull Distribution with parameters \code{mu} 
and \code{sigma} has density given by

\eqn{f(y) = \mu\sigma (-y) ^{\sigma - 1} e ^ {-\mu(-y)^\sigma},}

for y < 0
}
\examples{
# Example 1
# Generating some random values with
# known mu and sigma 
y <- rRW(n=100, mu=1, sigma=1)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, family= 'RW',
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu and sigma
# using the inverse link function
exp(coef(mod, 'mu'))
exp(coef(mod, 'sigma'))

# Example 2
# Generating random values under some model
n <- 200
x1 <- runif(n, min=0.4, max=0.6)
x2 <- runif(n, min=0.4, max=0.6)
mu <- exp(1.5 - 1.5 * x1)
sigma <- exp(2 - 2 * x2)
x <- rRW(n=n, mu, sigma)

mod <- gamlss(x~x1, sigma.fo=~x2, family=RW,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")

}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{Clifford1973}{RelDists}
}
\seealso{
\link{dRW}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
