% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simulated_changepoints}
\alias{simulated_changepoints}
\title{Simulated Changepoints Benchmark Dataset}
\format{
A list with multiple scenarios:
\describe{
\item{single_mean}{Single mean change from 0 to 3}
\item{single_variance}{Single variance change from 1 to 9}
\item{multiple_mean}{Three mean changes}
\item{gradual}{Gradual trend change (challenging)}
\item{small_change}{Small mean change of 0.5 SD (challenging)}
\item{close_changepoints}{Three closely spaced changepoints (challenging)}
\item{heavy_tailed}{Mean change with t-distributed noise}
\item{multivariate}{Bivariate mean and covariance change}
}

Each scenario contains:
\itemize{
\item \code{data}: The time series data
\item \code{true_changepoints}: Vector of true changepoint locations
\item \code{type}: Type of change (mean, variance, etc.)
\item \code{description}: Description of the scenario
}
}
\source{
Simulated data for package benchmarking
}
\usage{
simulated_changepoints
}
\description{
A collection of simulated datasets with known changepoints for benchmarking
changepoint detection methods.
}
\examples{
\donttest{
data(simulated_changepoints)

# Run benchmark on single mean scenario
scenario <- simulated_changepoints$single_mean
result <- detect_regimes(scenario$data, method = "pelt")
evaluate(result, true_changepoints = scenario$true_changepoints)

# Compare multiple methods
comparison <- compare_methods(
  data = scenario$data,
  methods = c("pelt", "bocpd", "binseg"),
  true_changepoints = scenario$true_changepoints
)
print(comparison)
}
}
\keyword{datasets}
