% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Runmimix.R
\name{RefBasedMI}
\alias{RefBasedMI}
\title{Reference-based multiple imputation of longitudinal data}
\usage{
RefBasedMI(
  data,
  covar = NULL,
  depvar,
  treatvar,
  idvar,
  timevar,
  method = NULL,
  reference = NULL,
  methodvar = NULL,
  referencevar = NULL,
  K0 = NULL,
  K1 = NULL,
  delta = NULL,
  dlag = NULL,
  M = 1,
  seed = 101,
  prior = "jeffreys",
  burnin = 1000,
  bbetween = NULL,
  mle = FALSE
)
}
\arguments{
\item{data}{Dataset in long format}

\item{covar}{Baseline covariate(s): must be complete (no missing values)}

\item{depvar}{Outcome variable}

\item{treatvar}{Treatment group variable: can be numeric or character}

\item{idvar}{Participant identifiervariable}

\item{timevar}{Variable indicating time point for repeated measures}

\item{method}{Reference-based imputation method: must be "J2R", "CR", "CIR", "MAR", "Causal" or "LMCF"}

\item{reference}{Reference group for "J2R", "CIR", "CR" methods, or control group for causal method: can be numeric or string}

\item{methodvar}{Variable in dataset specifying individual method}

\item{referencevar}{Variable in dataset specifying reference group for individual method}

\item{K0}{Causal constant for use with Causal method}

\item{K1}{Exponential decaying causal constant for use with Causal method}

\item{delta}{Optional vector of delta values to add onto imputed values (non-mandatory) (a's in Five_Macros user guide), length equal to number of time points}

\item{dlag}{Optional vector of delta values to add onto imputed values (non-mandatory) (b's in Five_Macros user guide), length equal to number of time points}

\item{M}{Number of imputations to be created}

\item{seed}{Seed value: specify this so that a new run of the command will give the same imputed values}

\item{prior}{Prior when fitting multivariate normal distributions: can be one of "jeffreys" (default), "uniform" or "ridge"}

\item{burnin}{Number of burn-in iterations when fitting multivariate normal distributions}

\item{bbetween}{Number of iterations between imputed data sets when fitting multivariate normal distributions}

\item{mle}{Use with extreme caution: do improper imputation by drawing from the model using the maximum likelihood estimates. This does not allow for uncertainty in the MLEs and invalidates interval estimates from Rubin's rules.}
}
\value{
A data frame containing the original data stacked above the M imputed data sets. The original ID variable (idvar) is renamed as .id. A new variable .imp indicates the original data (.imp=0) or the imputed data sets (.imp=1,...,M).
}
\description{
Performs reference-based multiple imputation of longitudinal data where data are missing after treatment discontinuation. Methods available are missing at random, jump to reference, copy reference, copy increments in reference, last mean carried forward, the causal model, and delta-adjustment.
}
\details{
The program works through the following steps:
\enumerate{
\item Set up a summary table based on treatment arm and missing data pattern
(i.e. which timepoints are unobserved)
\item Fit a multivariate normal distribution to each treatment arm using MCMC methods in package norm2
\item Impute all interim missing values under a MAR assumption, looping over treatments and patterns
\item Impute all post-discontinuation missing values under the user-specified assumption,
looping over treatments and patterns (and over methodvar and referencevar if specified)
\item Perform delta-adjustment if specified
\item Repeat steps 2-5 M times and form into a single data frame
}

The baseline value of the outcome could be handed as an outcome, but this would allow a treatment effect at baseline. We instead recommend handling it as a covariate.

The program is based on Suzie Cro's Stata program mimix

The user can use the as.mids() function in the mice package to convert the output data to mids data type and then perform analysis using Rubin's rules.
}
\examples{
# Perform jump to reference imputation on asthma trial data, with reference arm 1 
asthmaJ2R <- RefBasedMI(data=asthma, depvar=fev, treatvar=treat, 
 idvar=id, timevar=time, method="J2R", reference=1, M=5, seed=54321)
# Fit regression model to each imputed data set by treating output data frame as mids object
library(mice)
fit <- with(data = as.mids(asthmaJ2R), lm(fev ~ factor(treat), subset=(time==12)))
# Find pooled treatment effects using Rubin's rules 
summary(pool(fit))
}
