% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResurvcvIndividualData.R
\name{ReSurvCV}
\alias{ReSurvCV}
\title{K fold cross-validation of a \code{ReSurv} model.}
\usage{
ReSurvCV(
  IndividualDataPP,
  model,
  hparameters_grid,
  folds,
  random_seed,
  continuous_features_scaling_method = "minmax",
  print_every_n = 1L,
  nrounds = NULL,
  early_stopping_rounds = NULL,
  epochs = 1,
  parallel = FALSE,
  ncores = 1,
  num_workers = 0,
  verbose = FALSE,
  verbose.cv = FALSE
)
}
\arguments{
\item{IndividualDataPP}{\code{IndividualDataPP} object to use for the \code{ReSurv} fit cross-validation.}

\item{model}{\code{character}, machine learning for cross validation.}

\item{hparameters_grid}{\code{list}, grid of the hyperparameters to cross-validate.}

\item{folds}{\code{integer}, number of folds (i.e. K).}

\item{random_seed}{\code{integer}, random seed for making the code reproducible.}

\item{continuous_features_scaling_method}{\code{character}, method for scaling continuous features.}

\item{print_every_n}{\code{integer}, specific to the \code{XGB} approach, see \code{xgboost::xgb.train} documentation.}

\item{nrounds}{\code{integer}, specific to \code{XGB}, max number of boosting iterations.}

\item{early_stopping_rounds}{\code{integer}, specific to the \code{XGB} approach, see \code{xgboost::xgb.train} documentation.}

\item{epochs}{\code{integer}, specific to the \code{NN} approach, epochs to be checked.}

\item{parallel}{\code{logical}, specific to the \code{NN} approach, whether to use parallel computing.}

\item{ncores}{\code{integer}, specific to \code{NN}, max number of cores used.}

\item{num_workers}{\code{numeric}, number of workers for the \code{NN} approach, multi-process data loading with the specified number of loader worker processes.}

\item{verbose}{\code{logical}, whether messages from the machine learning models must be printed.}

\item{verbose.cv}{\code{logical}, whether messages from cross-validation must be printed.}
}
\value{
Best \code{ReSurv} model fit. The output is different depending on the machine learning approach that is required for cross-validation. A list containing:
 \itemize{
\item{\code{out.cv}: \code{data.frame}, total output of the cross-validation (all the input parameters combinations). }
\item{\code{out.cv.best.oos}:  \code{data.frame}, combination with the best out of sample likelihood. }
}

For XGB the columns in \code{out.cv} and \code{out.cv.best.oos} are the hyperparameters \code{booster}, \code{eta}, \code{max_depth}, \code{subsample}, \code{alpha}, \code{lambda}, \code{min_child_weight}. They also contain the metrics \code{train.lkh}, \code{test.lkh}, and the computational time \code{time}. For NN the columns in \code{out.cv} and \code{out.cv.best.oos} are the hyperparameters \code{num_layers}, \code{optim}, \code{activation}, \code{lr}, \code{xi}, \code{eps}, \code{tie}, \code{batch_size}, \code{early_stopping}, \code{patience}, \code{node} train.lkh test.lkh. They also contain the metrics \code{train.lkh}, \code{test.lkh}, and the computational time \code{time}.
}
\description{
This function computes a K fold cross-validation of a pre-specified machine learning model supported from the \code{ReSurv} package for a given grid of hyperparameters.
The hyperparameters to be tested are provided in a list, namely \code{hparameters_grid}.
Conversely, the parameters for the models run are provided separately as arguments and they are specific for each machine learning model support from.
}
\references{
Munir, H., Emil, H., & Gabriele, P. (2023). A machine learning approach based on survival analysis for IBNR frequencies in non-life reserving. arXiv preprint arXiv:2312.14549.
}
