% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndividualDataPP.R
\name{IndividualDataPP}
\alias{IndividualDataPP}
\title{Individual Data Pre-Processing}
\usage{
IndividualDataPP(
  data,
  id = NULL,
  continuous_features = NULL,
  categorical_features = NULL,
  accident_period,
  calendar_period,
  input_time_granularity = "months",
  output_time_granularity = "quarters",
  years = NULL,
  calendar_period_extrapolation = FALSE,
  continuous_features_spline = NULL,
  degrees_cf = 3,
  degrees_of_freedom_cf = 4,
  degrees_cp = 3,
  degrees_of_freedom_cp = 4
)
}
\arguments{
\item{data}{\code{data.frame}, for the individual reserving. The number of development periods can be larger than the number of accident periods.}

\item{id}{\code{character}, \code{data} column that contains the policy identifier. If \code{NULL} (default), we assume that each row is an observation. We assume that each observation can only have one reporting time, if not null we take the reporting time of the first row for each \code{id}.}

\item{continuous_features}{\code{character}, continuous features columns to be scaled.}

\item{categorical_features}{\code{character}, categorical features columns to be one-hot encoded.}

\item{accident_period}{\code{character}, it contains the name of the column in data corresponding to the accident period.}

\item{calendar_period}{\code{character}, it contains the name of the column in data corresponding to the calendar period.}

\item{input_time_granularity}{\code{character}, time unit of the input data. Granularity supported:
\itemize{
\item{\code{"days"}: the input data are daily.}
\item{\code{"months"}: the input data are monthly.}
\item{\code{"quarters"}: the input data are quarterly}
\item{\code{"years"}: the input data are yearly.}
}
Default to \code{months}.}

\item{output_time_granularity}{\code{character}, time unit of the output data. The granularity supported is the same as for the input data:
 \itemize{
 \item{\code{"days"}: the output data will be on a daily scale.}
\item{\code{"months"}: the output data will be on a monthly scale.}
\item{\code{"quarters"}: the output data will be on a quarterly scale.}
\item{\code{"years"}: the output data will be on yearly scale.}
}
The output granularity must be bigger than the input granularity.
Also, the output granularity must be consistent with the input granularity, meaning that the time conversion must be possible.
E.g., it is possible to group quarters to years. It is not possible to group quarters to semesters.
Default to \code{quarters}.}

\item{years}{\code{numeric}, number of development years in the study.}

\item{calendar_period_extrapolation}{\code{character}, whether a spline for calendar extrapolation should be considered in the cox model fit.
Default is `FALSE`.}

\item{continuous_features_spline}{\code{logical}, weather a spline for smoothing continuous features should be added.}

\item{degrees_cf}{\code{numeric}, degrees of the spline for smoothing continuous features.}

\item{degrees_of_freedom_cf}{\code{numeric}, degrees of freedom of the splines for smoothing continuous features.}

\item{degrees_cp}{\code{numeric}, degrees of the spline for smoothing the calendar period effect.}

\item{degrees_of_freedom_cp}{\code{numeric}, degrees of freedom of the splines for smoothing the calendar period effect.}
}
\value{
\code{IndividualDataPP} object. A list containing
\itemize{
\item{\code{full.data}: \code{data.frame}. The input data after pre-processing.}
\item{\code{starting.data}: \code{data.frame}. The input data as they were provided from the user.}
\item{\code{training.data}: \code{data.frame}. The input data pre-processed for training.}
\item{\code{conversion_factor}: \code{numeric}. The conversion factor for going from input granularity to output granularity. E.g, the conversion factor for going from months to quarters is 1/3.}
\item{\code{string_formula_i}: \code{character}. The \code{survival} formula to model the data in input granularity.}
\item{\code{string_formula_o}: \code{character}. The \code{survival} formula to model the in data output granularity.}
\item{\code{continuous_features}: \code{character}. The continuous features names as provided from the user.}
\item{\code{categorical_features}: \code{character}. The categorical features names as provided from the user.}
\item{\code{calendar_period_extrapolation}: \code{logical}. The value specifying if a calendar period component is extrapolated.}
\item{\code{years}: \code{numeric}. Total number of development years in the data. Default is NULL and computed automatically from the data.}
\item{\code{accident_period}: \code{character}. Accident period column name.}
\item{\code{calendar_period}: \code{character}. Calendar_period column name.}
\item{\code{input_time_granularity}: \code{character}. Input time granularity.}
\item{\code{output_time_granularity}: \code{character}. Output time granularity.}
}


After pre-processing, we provide a standard encoding for the time components. This regards the output in \code{training.data} and \code{full.data}.
In the \code{ReSurv} notation:
\itemize{
\item{\code{AP_i}: Input granularity accident period.}
\item{\code{AP_o}: Output granularity accident period.}
\item{\code{DP_i}: Input granularity development period in forward time.}
\item{\code{DP_rev_i}: Input granularity development period in reverse time.}
\item{\code{DP_rev_o}: Output granularity development period in reverse time.}
\item{\code{TR_i}: Input granularity truncation time.}
\item{\code{TR_o}: Output granularity truncation time.}
\item{\code{I}: event indicator, under this framework is equal to one for each entry. }
}
}
\description{
This function pre-processes the data for the application of a \code{ReSurv} model.
}
\details{
The input \code{accident_period} is coded as \code{AP_i}. The input development periods are derived as \code{DP_i}=\code{calendar_period}-\code{accident_period}+1.

The reverse time development factors are \code{DP_rev_i} = \code{DP_max}-\code{DP_i}, where \code{DP_max} is the maximum number of development times: \code{DP_i} \eqn{=1,\ldots,}\code{DP_max}. Given the parameter \code{years}, \code{DP_max} is derived internally from our package.

As for the truncation time, \code{TR_i} = \code{AP_i}-1.

\code{AP_i}, \code{DP_i}, \code{DP_rev_i} and \code{TR_i} are converted to \code{AP_o}, \code{DP_o}, \code{DP_rev_o} and \code{TR_o} (from the \code{input_time_granularity} to the \code{output_time_granularity}) using a multiplicative conversion factor. E.g., \code{AP_o} = \code{AP_i} * \eqn{CF}.


The conversion factor is computed as

\eqn{CF=\frac{{\nu}^i}{({\nu}^o)^{-1}}},

where \eqn{{\nu}^i} and \eqn{{\nu}^o} are the fraction of a year corresponding to \code{input_time_granularity} and \code{output_time_granularity}. \eqn{{\nu}^i} and \eqn{{\nu}^o} take values \code{1/360, 1/12, 1/4, 1/2, 1} for \code{"days", "months", "quarters", "semesters", "years"} respectively.
We will have \code{RP_o} = \code{AP_o} + \code{DP_o}.
}
\examples{

input_data_0 <- data_generator(
random_seed = 1964,
scenario = "alpha",
time_unit = 1,
years = 2,
period_exposure = 100)

individual_data <- IndividualDataPP(data = input_data_0,
categorical_features = "claim_type",
continuous_features = "AP",
accident_period = "AP",
calendar_period = "RP",
input_time_granularity = "years",
output_time_granularity = "years",
years = 2)




}
\references{
Munir, H., Emil, H., & Gabriele, P. (2023). A machine learning approach based on survival analysis for IBNR frequencies in non-life reserving. arXiv preprint arXiv:2312.14549.
}
