% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basismfdClass.R
\name{basismfd}
\alias{basismfd}
\alias{Basismfd}
\title{Define a Set of Multidimensional Functional Basis}
\usage{
Basismfd(...)

Basismfd(...)
}
\arguments{
\item{...}{A list of `basisfd` objects}
}
\description{
The `basismfd` class represents a set of  multidimensional basis functions. This class utilizes basis objects 
from the `fda` package, such as B-splines and Fourier bases.

Constructor for `basismfd` objects (same as Basismfd(...) )
}
\examples{
require(fda)
bs1 <- create.fourier.basis(c(0, 2 * pi), 5)
bs2 <- create.bspline.basis(c(0, 1), 7)
bs3 <- create.exponential.basis(c(0, 2), 3)
# 1-D Basis ######## (similar to the fd features)
mdbs1 <- Basismfd(bs1)
mdbs1$basis
mdbs1$dimSupp
mdbs1$nbasis
mdbs1$supp
mdbs1$gram
mdbs1$eval(1:7 / 10)
image(as.matrix(mdbs1$gram))

####### 2-D Basis ######## (fd cannot handle this)
mdbs2 <- Basismfd(bs1, bs2)
mdbs2$basis
mdbs2$dimSupp
mdbs2$nbasis
mdbs2$supp
dim(mdbs2$gram)
arg_mdbs <- list(1:10, 1:9 / 10)
mdbs2$eval(arg_mdbs)
image(as.matrix(mdbs2$gram))
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{basis}}{A list of basis objects from the `fda` package.}

\item{\code{dimSupp}}{The dimension of the support domain of the `basismfd` object.}

\item{\code{supp}}{The matrix representing the ranges of the dimensions.}

\item{\code{gram}}{The Gram matrix.}

\item{\code{nbasis}}{A numeric vector containing the number of bases.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-basismfd-new}{\code{basismfd$new()}}
\item \href{#method-basismfd-eval}{\code{basismfd$eval()}}
\item \href{#method-basismfd-print}{\code{basismfd$print()}}
\item \href{#method-basismfd-clone}{\code{basismfd$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-basismfd-new"></a>}}
\if{latex}{\out{\hypertarget{method-basismfd-new}{}}}
\subsection{Method \code{new()}}{
The constructor function for objects of the class `basismfd` (same as Basismfd(...) )
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{basismfd$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{A list of `basisfd` objects}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-basismfd-eval"></a>}}
\if{latex}{\out{\hypertarget{method-basismfd-eval}{}}}
\subsection{Method \code{eval()}}{
Evaluate the `basismfd` object at given argument values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{basismfd$eval(evalarg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{evalarg}}{A list of numeric vectors of argument values at which the `basismfd` is to be evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of evaluated values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-basismfd-print"></a>}}
\if{latex}{\out{\hypertarget{method-basismfd-print}{}}}
\subsection{Method \code{print()}}{
Print method for `basismfd` objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{basismfd$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments to be passed to `print`
Getter and setter for `basis` field
Getter and setter for `dimSupp` field
Getter and setter for `nbasis` field
Getter and setter for `supp` field
Getter and setter for `gram` field}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-basismfd-clone"></a>}}
\if{latex}{\out{\hypertarget{method-basismfd-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{basismfd$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
