% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{em_hmm}
\alias{em_hmm}
\title{EM algorithm in combination with a non-parametric algorithm for estimation of the rLIS statistic.}
\usage{
em_hmm(pa_in, pb_in, pi0a_in, pi0b_in)
}
\arguments{
\item{pa_in}{A numeric vector of p-values from study 1.}

\item{pb_in}{A numeric vector of p-values from study 2.}

\item{pi0a_in}{An initial estimate of the null probability in study 1.}

\item{pi0b_in}{An initial estimate of the null probability in study 2.}
}
\value{
\item{rLIS}{The estimated rLIS for replicability null.}
\item{fdr}{The adjusted values based on rLIS for FDR control.}
\item{loglik}{The log-likelihood value with converged estimates of the unknowns.}
\item{pi}{An estimate of the stationary probabilities of four states {(0,0), (0,1), (1,0), (1,1)}.}
\item{A}{An estimate of the 4-by-4 transition matrix.}
\item{f1}{A non-parametric estimate for the non-null probability density function in study 1.}
\item{f2}{A non-parametric estimate for the non-null probability density function in study 2.}
}
\description{
Estimate the rLIS values accounting for the linkage disequilibrium across two genome-wide association studies via the four-state hidden Markov model. Apply a step-up procedure to control the FDR of replicability null.
}
