% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series-batch.R
\name{series_batch}
\alias{series_batch}
\alias{series_batch_query}
\alias{series_batch_query_raw}
\alias{series_batch_last_value}
\title{Batch queries API methods}
\usage{
series_batch_query(
  from,
  to,
  interval = NULL,
  Q,
  SeriesLimit = NULL,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

series_batch_query_raw(
  from,
  to,
  interval = NULL,
  Q,
  SeriesLimit = NULL,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

series_batch_last_value(
  thing_id,
  property_id,
  store_token = "option",
  token = NULL,
  silent = FALSE
)
}
\arguments{
\item{from}{A \code{Posixct} or \code{Date} object.
Get data with a timestamp >= to this value}

\item{to}{A \code{Posixct} or \code{Date} object.
Get data with a timestamp < to this value}

\item{interval}{(numeric) Resolutions in seconds (seems not to affect results)}

\item{Q}{The query. (Not clear what this means but allows to chose among properties by filling in,
for instance, \verb{property.fbf34284-91f0-42be-bbf6-dd46cfb3f1e0})}

\item{SeriesLimit}{Maximum number of values (seems not to affect results)}

\item{store_token}{Where your token is stored. If \code{option} it will be retrieved from the .Rprofile (not cross-session and default),
if \code{envir} it will be retrieved from environmental variables list (cross-session)}

\item{token}{A valid token created with \code{create_auth_token} or manually.
It not \code{NULL} it has higher priority then \code{store_token}}

\item{silent}{Whether to hide or show API method success messages (default \code{FALSE})}

\item{thing_id}{The id of the thing}

\item{property_id}{The id of the property}
}
\value{
A tibble showing of time and value for properties
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Returns the batch of time-series data or last data point for a property of given thing
(note: this API method is bugged and waiting to be fixed by Arduino team.
Here for completeness and future developments but would not suggest using it)

Official documentation:
\itemize{
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-SeriesV2-seriesV2BatchQuery}{seriesV2BatchQuery}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-SeriesV2-seriesV2BatchQueryRaw}{seriesV2BatchQueryRaw}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-SeriesV2-seriesV2BatchQueryRawLastValue}{seriesV2BatchQueryRawLastValue}
}
}
\examples{
\dontrun{
Sys.setenv(ARDUINO_API_CLIENT_ID = 'INSERT CLIENT_ID HERE')
Sys.setenv(ARDUINO_API_CLIENT_SECRET = 'INSERT CLIENT_SECRET HERE')

create_auth_token()

### series_batch_query ###
series_batch_query(from = "2022-08-15", to = "2022-08-22",
Q = "property.fbf34284-91f0-42be-bbf6-dd46cfb3f1e0")

### series_batch_query_raw ###
series_batch_query_raw(from = "2022-08-15", to = "2022-08-22",
Q = "property.fbf34284-91f0-42be-bbf6-dd46cfb3f1e0")

### series_batch_last_value ###
thing_id = "b6822400-2f35-4d93-b3e7-be919bdc5eba"
property_id = "fbf34284-91f0-42be-bbf6-dd46cfb3f1e0"

series_batch_last_value(thing_id = thing_id, property_id = property_id)
}
}
