% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{rduckhts_bcf}
\alias{rduckhts_bcf}
\title{Create VCF/BCF Table}
\usage{
rduckhts_bcf(
  con,
  table_name,
  path,
  region = NULL,
  index_path = NULL,
  tidy_format = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{con}{A DuckDB connection with DuckHTS loaded}

\item{table_name}{Name for the created table}

\item{path}{Path to the VCF/BCF file}

\item{region}{Optional genomic region (e.g., "chr1:1000-2000")}

\item{index_path}{Optional explicit path to index file (.csi/.tbi)}

\item{tidy_format}{Logical. If TRUE, FORMAT columns are returned in tidy format}

\item{overwrite}{Logical. If TRUE, overwrites existing table}
}
\value{
Invisible TRUE on success
}
\description{
Creates a DuckDB table from a VCF or BCF file using the DuckHTS extension.
This follows the RBCFTools pattern of creating a table that can be queried.
}
\examples{
library(DBI)
library(duckdb)

con <- dbConnect(duckdb::duckdb(config = list(allow_unsigned_extensions = "true")))
rduckhts_load(con)
bcf_path <- system.file("extdata", "vcf_file.bcf", package = "Rduckhts")
rduckhts_bcf(con, "variants", bcf_path, overwrite = TRUE)
dbGetQuery(con, "SELECT * FROM variants LIMIT 2")
dbDisconnect(con, shutdown = TRUE)

}
