% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_MVU.R
\name{do.mvu}
\alias{do.mvu}
\alias{do.sde}
\title{Maximum Variance Unfolding / Semidefinite Embedding}
\usage{
do.mvu(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten"),
  projtype = c("spectral", "kpca")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{projtype}{type of method for projection; either \code{"spectral"} or \code{"kpca"} used.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
The method of Maximum Variance Unfolding(MVU), also known as Semidefinite Embedding(SDE) is, as its names suggest,
to exploit semidefinite programming in performing nonlinear dimensionality reduction by \emph{unfolding}
neighborhood graph constructed in the original high-dimensional space. Its unfolding generates a gram
matrix \eqn{K} in that we can choose from either directly finding embeddings (\code{"spectral"}) or
use again Kernel PCA technique (\code{"kpca"}) to find low-dimensional representations.
}
\examples{
\donttest{
## use a small subset of iris data
set.seed(100)
id  = sample(1:150, 50)
X   = as.matrix(iris[id,1:4])
lab = as.factor(iris[id,5])

## try different connectivity levels
output1 <- do.mvu(X, type=c("proportion", 0.10))
output2 <- do.mvu(X, type=c("proportion", 0.25))
output3 <- do.mvu(X, type=c("proportion", 0.50))

## visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, main="10\% connected", pch=19, col=lab)
plot(output2$Y, main="25\% connected", pch=19, col=lab)
plot(output3$Y, main="50\% connected", pch=19, col=lab)
par(opar)
}

}
\references{
\insertRef{weinberger_unsupervised_2006}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
