% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_NPCA.R
\name{do.npca}
\alias{do.npca}
\title{Nonnegative Principal Component Analysis}
\usage{
do.npca(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 100).}
\item{reltol}{relative tolerance stopping criterion (default: 1e-4).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Nonnegative Principal Component Analysis (NPCA) is a variant of PCA where
projection vectors - or, basis for learned subspace - contain no negative values.
}
\examples{
\dontrun{
## use iris data
data(iris, package="Rdimtools")
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4]) + 50
label = as.factor(iris[subid,5])

## run NCPA and compare with others
outNPC = do.npca(X)
outPCA = do.pca(X)
outMVP = do.mvp(X, label)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(outNPC$Y, pch=19, col=label, main="NPCA")
plot(outPCA$Y, pch=19, col=label, main="PCA")
plot(outMVP$Y, pch=19, col=label, main="MVP")
par(opar)
}

}
\references{
\insertRef{zafeiriou_nonnegative_2010}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
\concept{linear_methods}
