% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSNOMED.R
\name{sampleSNOMED}
\alias{sampleSNOMED}
\title{Sample SNOMED CT dictionary}
\usage{
sampleSNOMED()
}
\value{
environment containing four data.table objects:
  CONCEPT, DESCRIPTION, RELATIONSHIP, STATEDRELATIONSHIP
  and a list named 'metadata'
}
\description{
Returns an environment containing a selection of SNOMED CT
terms, their relationships and descriptions which are
provided with the package
}
\examples{
TEST <- sampleSNOMED()
inactiveIncluded(TEST)
SNOMEDconcept('Heart failure', SNOMED = TEST)

# To display metadata for this SNOMED CT dictionary
sampleSNOMED()$metadata
}
\seealso{
CONCEPT, DESCRIPTION, RELATIONSHIP, STATEDRELATIONSHIP, 
REFSET, SIMPLEMAP, EXTENDEDMAP, HISTORY, QUERY, loadSNOMED, sampleSNOMED

Other sampleSNOMED: 
\code{\link{HISTORY}},
\code{\link{READMAPS}},
\code{\link{SNOMED_CONCEPT}},
\code{\link{SNOMED_DESCRIPTION}},
\code{\link{SNOMED_EXTENDEDMAP}},
\code{\link{SNOMED_REFSET}},
\code{\link{SNOMED_RELATIONSHIP}},
\code{\link{SNOMED_SIMPLEMAP}}
}
\concept{sampleSNOMED}
