% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concepts.R
\name{description}
\alias{description}
\title{Obtain descriptions for a set of SNOMED CT terms}
\usage{
description(
  conceptIds,
  include_synonyms = FALSE,
  active_only = TRUE,
  SNOMED = getSNOMED()
)
}
\arguments{
\item{conceptIds}{character or integer64 vector}

\item{include_synonyms}{whether to return all synonyms, or just the
Fully Specified Name, ensuring just one row per concept (default)}

\item{active_only}{whether to include only active descriptions}

\item{SNOMED}{environment containing SNOMED dictionary. Defaults
to an object named 'SNOMED' in the global environment}
}
\value{
a data.table with the following columns: id, conceptId, type
  (only if include_synonyms = TRUE), term,
  active (only if active_only = FALSE)
}
\description{
Returns the descriptions matching a set of concept IDs from
a SNOMED dictionary
}
\examples{
hf <- SNOMEDconcept('Heart failure', SNOMED = sampleSNOMED())
description(hf, include_synonyms = FALSE, SNOMED = sampleSNOMED())
}
\seealso{
htmlCodelistHierarchy
}
