% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prefix_distance}
\alias{prefix_distance}
\title{Calculate the prefix distance between two strings}
\usage{
prefix_distance(s1, s2, score_cutoff = NULL)
}
\arguments{
\item{s1}{A string. The first input string.}

\item{s2}{A string. The second input string.}

\item{score_cutoff}{An optional maximum threshold for the distance. Defaults to the largest
integer value in R (`.Machine$integer.max`).}
}
\value{
The prefix distance as an integer.
}
\description{
Computes the prefix distance, which measures the number of character edits required to convert
one prefix into another. This includes insertions, deletions, and substitutions.
}
\examples{
prefix_distance("abcdef", "abcxyz")
prefix_distance("abcdef", "abcxyz", score_cutoff = 3)
}
