% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-displacement-walk.R
\name{random_displacement_walk}
\alias{random_displacement_walk}
\title{Generate a Random Displacement Walk in 2D}
\usage{
random_displacement_walk(
  .num_walks = 25,
  .seed = NULL,
  .n = 100,
  .distance_space = c(0, 1, 2, 3, 4),
  .displacement = c(-1, 1),
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{An integer specifying the number of random walks to generate. Default is 25.}

\item{.seed}{An optional value to set the random seed. If NULL, no seed is set. Default is NULL.}

\item{.n}{The number of steps in the walk. Must be >= 0. Default is 100.}

\item{.distance_space}{A numeric vector of possible step distances. Default is c(0, 1, 2, 3, 4).}

\item{.displacement}{A numeric vector of possible step directions. Default is c(-1, 1).}

\item{.dimensions}{An integer specifying the number of dimensions (1, 2, or 3). Default is 1.}
}
\value{
A tibble with columns depending on the number of dimensions:
\itemize{
\item \code{step_number}: Step index.
\item \code{y}: If \code{.dimensions = 1}, the value of the walk at each step.
\item \code{x}, \code{y}: If \code{.dimensions = 2}, the values of the walk in two dimensions.
\item \code{x}, \code{y}, \code{z}: If \code{.dimensions = 3}, the values of the walk in three dimensions.
}

The tibble includes attributes for the function parameters.
}
\description{
The \code{random_displacement_walk} function generates a single random walk in 2 dimensions (x, y),
where each step is a random displacement in both x and y directions, sampled from the provided
displacement and distance spaces. The walk disregards steps where both x and y displacements are zero.
}
\examples{
random_displacement_walk(.n = 10, .seed = Sys.Date())

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_gamma_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}

Other Discrete Distribution: 
\code{\link{discrete_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Discrete Distribution}
\concept{Generator Functions}
