% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaMS-package.R
\docType{package}
\name{RaMS-package}
\alias{RaMS}
\alias{RaMS-package}
\title{RaMS: R Access to Mass-Spec Data}
\description{
R-based access to mass-spectrometry (MS) data. While many packages exist to process MS data, many of these make it difficult to access the underlying mass-to-charge ratio (m/z), intensity, and retention time of the files themselves. This package is designed to format MS data in a tidy fashion and allows the user perform the plotting and analysis.
}
\details{
The main function of RaMS is \code{\link[=grabMSdata]{grabMSdata()}}, which handles most use-cases and
automatically detects file types and is vectorized over multiple files. If
more control over the file reading is desired, both \code{\link[=grabMzmlData]{grabMzmlData()}} and
\code{\link[=grabMzxmlData]{grabMzxmlData()}} have been exposed to the user, and \code{\link[=grabAccessionData]{grabAccessionData()}} is
available if a specific accession value from an mzML file is desired.

Other useful functions in the package include \code{\link[=minifyMSdata]{minifyMSdata()}} and
\code{\link[=tmzmlMaker]{tmzmlMaker()}} which have their own documentation pages and vignettes. Two
small helper functions are also included, \code{\link[=pmppm]{pmppm()}} and \code{\link[=between]{between()}} (with the
alias \verb{\%between\%}) imported from \code{data.table}.

See the package intro on GitHub at https://github.com/wkumler/RaMS and
explore the vignette with \code{vignette("Intro-to-RaMS", package = "RaMS")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wkumler/RaMS}
  \item Report bugs at \url{https://github.com/wkumler/RaMS/issues}
}

}
\author{
\strong{Maintainer}: William Kumler \email{wkumler@uw.edu} [copyright holder]

Other contributors:
\itemize{
  \item Ricardo Cunha [contributor]
  \item Ethan Bass [contributor]
}

}
\keyword{internal}
