% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooroh_accessor.R
\name{rohbd}
\alias{rohbd}
\title{Extracts the HBD segments from the zres object}
\usage{
rohbd(
  zres,
  ids = NULL,
  chrom = NULL,
  startPos = NULL,
  endPos = NULL,
  inside = TRUE
)
}
\arguments{
\item{zres}{The name of the zres object created by the zoorun function.}

\item{ids}{An array with the ids of the individuals to extract. All individuals
are extracted by default.}

\item{chrom}{the number of the chromosome where we are looking for HBD segments.
This chromosome number refers to the position of the chromosome in the list
of all chromsomes present in the input genotype data.}

\item{startPos}{The starting position (on the chromosome) of the interval from which we will extract HBD segments
(1 by default).}

\item{endPos}{The ending position (on the chromosome) of the interval from which we will extract HBD segments
(last position by default).}

\item{inside}{A logical indicating whether we extract only segment within the interval (TRUE) or overlapping with the
interval (FALSE). By 'within the interval', we mean that both starting and end position of the HBD segment should be
in the interval. By 'overlapping', we mean that at least one part of the HBD segment should be located in the
interval.}
}
\value{
The function returns a data frame  with the HBD segments fitting the filtering rules (id and position).
The data frame has one line per identified HBD segment and nine columns: id is the number of the individual in
which the HBD segments is located, chrom is the chromosome of the HBD segments, start_snp is the number of the SNP
at which the HBD segment starts (the SNP number within the chromosome), start_end is the number of the SNP at
which the HBD segment ends (the SNP number within the chromosome), start_pos is the position at which the HBD
segment starts (within the chromosome), start_end is the position at which the HBD segment ends (within the
chromosome), number_snp is the number of consecutive SNPs in the HBD segment, length is the length of the HBD
segment (for instance in bp or in cM/1000000) and HBDclass is the HBD class associated with the HBD segment.
}
\description{
Extracts the HBD segments (or RoH) from the zres object. Extraction is performed
for the indicated individuals and the selected region (all by default).
}
