% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WBjdoql.R
\name{WBjdoql}
\alias{WBjdoql}
\title{Generate the JDOQL query for the search in the Wildbook framework.}
\usage{
WBjdoql(object = "encounter", location = NULL, locationID = NULL,
  sighting_date = c("1964-01-01", "2016-12-31"),
  encounter_submission_dates = c("2003-01-01", "2016-12-31"),
  date_format = "\%Y-\%m-\%d", sex = c("male", "female", "unknown"),
  status = c("alive", "dead"), measurement = NULL, individualID = NULL,
  encounterID = NULL, encounter_type = NULL, Date_of_birth = NULL,
  Date_of_death = NULL)
}
\arguments{
\item{object}{can be either "encounter" for the encounter search or "individual" for the individual search.}

\item{location}{A string of character contained in location names.}

\item{locationID}{A character vector for filtering the locationID.}

\item{sighting_date}{A character for filtering encounters which are sighted during a period of time.}

\item{encounter_submission_dates}{A character for filtering encounters which are submitted during a period of time.}

\item{date_format}{The format for all the arguments of date valule.}

\item{sex}{A character vector of maximum size of three represents the value for the sex filter.}

\item{status}{A character vector of maximum size of two represents the value for the encounter status.}

\item{measurement}{A numeric object sets the minimum individual measurement when searching in the Wildbook framework.}

\item{individualID}{A character vector for searching data of specific individual ID.}

\item{encounterID}{A character vector for searching data of specific encounter ID.}

\item{encounter_type}{A character vector of maximum size of three for searching data with specific encounter type.}

\item{Date_of_birth}{A character vector for searching data of individual which is borned during a period of time.}

\item{Date_of_death}{A character vector for searching data of individual which is dead during a period of time.}
}
\description{
This function generate the JDOQL query string according to the filters specified by users. The JDOQL query is an essential part of the search URL.
}

