/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.RandomSubSpace;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.ResampleUtils;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class WeightedInstancesHandlerWrapper
extends RandomizableSingleClassifierEnhancer
implements WeightedInstancesHandler {
    private static final long serialVersionUID = 2980789213434466135L;
    public static final String FORCE_RESAMPLE_WITH_WEIGHTS = "force-resample-with-weights";
    protected boolean m_ForceResampleWithWeights = false;

    public String globalInfo() {
        return "Generic wrapper around any classifier to enable weighted instances support.\nUses resampling with weights if the base classifier is not implementing the " + WeightedInstancesHandler.class.getName() + " interface and there are instance weights other than 1.0 present. By default, the training data is passed through to the base classifier if it can handle instance weights. However, it is possible to force the use of resampling with weights as well.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tForces resampling of weights, regardless of whether\n\tbase classifier handles instance weights", FORCE_RESAMPLE_WITH_WEIGHTS, 0, "-force-resample-with-weights"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setForceResampleWithWeights(Utils.getFlag(FORCE_RESAMPLE_WITH_WEIGHTS, options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getForceResampleWithWeights()) {
            result.add("-force-resample-with-weights");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public boolean getForceResampleWithWeights() {
        return this.m_ForceResampleWithWeights;
    }

    public void setForceResampleWithWeights(boolean value) {
        this.m_ForceResampleWithWeights = value;
    }

    public String forceResampleWithWeightsTipText() {
        return "If enabled, forces the data to be resampled with weights, regardless of whether the base classifier can handle instance weights.";
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        boolean resample;
        this.getCapabilities().testWithFail(data);
        boolean bl = resample = this.getForceResampleWithWeights() || !(this.m_Classifier instanceof WeightedInstancesHandler) && ResampleUtils.hasInstanceWeights(data);
        if (resample) {
            if (this.getDebug()) {
                System.err.println(this.getClass().getName() + ": resampling training data");
            }
            data = data.resampleWithWeights(new Random(this.m_Seed));
        }
        this.m_Classifier.buildClassifier(data);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        return this.m_Classifier.classifyInstance(instance);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()).append("\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=")).append("\n\n");
        result.append("Force resample with weights: " + this.getForceResampleWithWeights() + "\n");
        result.append("Base classifier:\n");
        result.append("- command-line: " + Utils.toCommandLine(this.m_Classifier) + "\n");
        result.append("- handles instance weights: " + (this.m_Classifier instanceof WeightedInstancesHandler) + "\n\n");
        result.append(this.m_Classifier.toString());
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12226 $");
    }

    public static void main(String[] args) {
        WeightedInstancesHandlerWrapper.runClassifier(new RandomSubSpace(), args);
    }
}

