% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advector.R
\name{ADoverload}
\alias{ADoverload}
\title{Enable extra RTMB convenience methods}
\usage{
ADoverload(x = c("[<-", "c", "diag<-"))
}
\arguments{
\item{x}{Name of primitive to overload}
}
\value{
Function representing the overload.
}
\description{
Enable extra RTMB convenience methods
}
\details{
Work around limitations in R's method dispatch system by overloading some selected primitives, currently:
\itemize{
\item Inplace replacement, so you can do \code{x[i] <- y} when \code{x} is numeric and \code{y} is AD.
\item Mixed combine, so you can do e.g. \code{c(x, y)} when \code{x} numeric and \code{y} is AD.
\item Diagonal assignment, so you can do \code{diag(x) <- y} when \code{x} is a numeric matrix and \code{y} is AD.
}

In all cases, the result should be AD.
The methods are automatically \strong{temporarily} attached to the search path (\code{search()}) when entering \link{MakeTape} or \link{MakeADFun}.
Alternatively, methods can be overloaded locally inside functions using e.g. \code{"[<-" <- ADoverload("[<-")}. This is only needed when using RTMB from a package.
}
\examples{
MakeTape(function(x) {print(search()); x}, numeric(0))
MakeTape(function(x) c(1,x), 1:3)
MakeTape(function(x) {y <- 1:3; y[2] <- x; y}, 1)
MakeTape(function(x) {y <- matrix(0,3,3); diag(y) <- x; y}, 1:3)
}
