% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait_selection_function.R
\name{rtcc1}
\alias{rtcc1}
\title{Trait selection}
\usage{
rtcc1(table1, table2, table3, traits_columns, repetitions)
}
\arguments{
\item{table1}{A data frame containing organisms names on the first column and its trait values on the
consecutive ones. It also has to contain two columns with the maximum and the minimum values of the tested
environmental variable where the organisms have been observed.}

\item{table2}{A presence-absence observations table with the organisms names on the first column and the
sample names as consecutive colnames.}

\item{table3}{A dataframe containing sample names on the first column and environmental parameters on the
consecutive ones.}

\item{traits_columns}{Table 1 column numbers where different trait values appear.}

\item{repetitions}{Number of simulated synthetic communities distributions.}
}
\value{
The function returns a dataframe with trait names as colnames and the p-value distribution of the different
traits.
}
\description{
This function determines whether the selected traits exhibit or not a clustering/overdispersion
signal on the tested samples. For each trait, compares the observed Mean Pairwise Distance (MPD)
of each sample against a distribution of synthetic commmunities MPDs obtained by a randomization
test. Each synthetic community is build maintaining the original sample richness and randomly
selecting organisms form the global pool.
}
\examples{

\donttest{
data(group_information)
data(table_presence_absence)
data(metadata)
rtcc1(group_information, table_presence_absence, metadata, 2:11, 100)
}


}
