% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empiricalsmalltelescopes.R
\name{SmallTelescopes}
\alias{SmallTelescopes}
\title{Small Telescopes}
\usage{
SmallTelescopes(
  data,
  analysis,
  n.original,
  B.CI = 10000,
  CI.level = 0.9,
  B.power = 10000,
  alpha = 0.05,
  n.rows = 1,
  seed = 1
)
}
\arguments{
\item{data}{Dataset (matrix).}

\item{analysis}{Function to produce a p value and an effect size estimate.}

\item{n.original}{The sample size of the original analysis (scalar).}

\item{B.CI}{The number of simulated samples used to construct CI (scalar); default = 10,000.}

\item{CI.level}{The confidence level of the interval (scalar); default = .90.}

\item{B.power}{The number of samples to be simulated (scalar); default = 10,000.}

\item{alpha}{Set alpha level for analysis (scalar); default = 0.05.}

\item{n.rows}{The number of rows per subject in the dataset (scalar); default = 1.}

\item{seed}{Allows randomly generated numbers to be reproducible (scalar); default = 1.}
}
\value{
Displays statistical power for point estimate of an effect size plus the lower and upper
bounds of a confidence interval. List contains the following components:
\item{n.replication}{The sample size of the replication analysis.}
\item{n.original}{The sample size of the original analysis.}
\item{B.CI}{The number of simulated samples used to construct CI.}
\item{CI.level}{The confidence level of the interval.}
\item{B.power}{The number of samples simulated.}
\item{p.value}{The p value calculated from the replication data}
\item{es.estimate}{Point estimate of effect size.}
\item{es.power}{Estimated power for the point estimate of effect size.}
\item{CI.lower.estimate}{Effect size estimate at the lower bound of the CI.}
\item{CI.lower.power}{Estimated power for the lower bound of the CI.}
\item{CI.upper.estimate}{Effect size estimate at the upper bound of the CI.}
\item{CI.upper.power}{Estimated power for the upper bound of the CI.}
}
\description{
Estimate statistical power for point estimate of effect size plus the lower
and upper bounds of a confidence interval.
}
\examples{
# create or import dataset
 example.data <- matrix(rnorm(50), 25, 2)

# conduct empirical small telescopes analysis
 SmallTelescopes(
   data = example.data, 
   analysis = function(data) {
     corr <- cor.test(data[,1], data[,2])
     return(list(effect.size = corr$estimate, p.value = corr$p.value))
   }, 
   n.original = 10, 
   B.CI = 100, 
   B.power = 100)
}
