% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col2mesh.R
\name{col2mesh}
\alias{col2mesh}
\title{Color a mesh according to provided values}
\usage{
col2mesh(mesh,values,pal,from=NULL,to=NULL,NAcol="gray90")
}
\arguments{
\item{mesh}{a \code{mesh3d} object.}

\item{values}{a vector of continuous values associated to individual vertices
of the \code{mesh}.}

\item{pal}{a vector of colors to be passed to
\code{\link[grDevices]{colorRampPalette}}.}

\item{from, to}{lower and upper \code{values} to be associated to the ends of
\code{pal}.}

\item{NAcol}{the color associated to NA \code{values}.}
}
\value{
A \code{mesh3d} object colored according to \code{values}.
}
\description{
The function colors a \code{mesh} according to a vector of
  continuous \code{values} related to individual vertices.
}
\examples{
  \donttest{
  da<-"https://github.com/pasraia/RRmorph_example_data/raw/refs/heads/main/RRmorphdata.rda"
  download.file(url=da,destfile = paste0(tempdir(),"/RRmorphdata.rda"))
  load(paste0(tempdir(),"/RRmorphdata.rda"))

  require(rgl)
  require(Morpho)
  require(Rvcg)

  pca<-procSym(endo.set)
  ldm<-endo.set[,,"Homo_sapiens"]
  sur<-endo.sur[["Homo_sapiens"]]

  rec<- vcgBallPivoting(pca$mshape, radius = 0)
  rec$vb[1:3,]<-t(ldm)
  val<-rnorm(ncol(rec$vb))

  interp<-interpolMesh(sur = rec,refsur = sur,refmat = ldm,
                       values = val,element ="vertices",k = 4)

  colmesh<-col2mesh(mesh = sur,values = interp,pal = heat.colors(5))
  plotLegend(mesh = colmesh,values = interp, main = "Pan troglodytes")
  open3d()
  shade3d(colmesh,specular="black")
  }
}
\author{
Marina Melchionna, Silvia Castiglione
}
