% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projections.R
\name{sparse_proj}
\alias{sparse_proj}
\title{Sparse projections using the square-root Lasso}
\usage{
sparse_proj(x, x_null, x_alt, mc.cores = 1L, rescale = FALSE, ...)
}
\arguments{
\item{x}{Matrix with each row an observation vector. Need not be supplied if
\code{x_alt} and \code{x_null} are given.}

\item{x_null}{Matrix whose columns are to be regressed on to \code{x_alt}.}

\item{x_alt}{Matrix which the columns of \code{x_null} are regressed on to.
Must be specified if \code{x_null} is given.}

\item{mc.cores}{The number of cores to use. Will always be 1 in Windows.}

\item{rescale}{Should the columns of the output be rescaled to have l_2-norm
the square-root of the number of observations? Default is \code{FALSE}.}

\item{...}{Additional arguments to be passed to \code{sqrt_lasso}.}
}
\value{
A matrix where each column gives the residuals.
}
\description{
Regresses each column of \code{x} against all others in turn, using the
square-root Lasso, and outputs residuals from the regressions. Thus it
outputs a form of sparse projection of each column on all others.
Alternatively, given two matrices \code{x_null} and \code{x_alt}, it
regresses each column of \code{x_null} on \code{x_alt} in a similar fashion.
}
\examples{
x <- matrix(rnorm(50*100), 50, 100)
out <- sparse_proj(x)
}
\references{
A. Belloni, V. Chernozhukov, and L. Wang. (2011)
  \emph{Square-root lasso: pivotal recovery of sparse signals via conic
  programming. Biometrika, 98(4):791-806.}

  T. Sun and C.-H. Zhang. (2012) \emph{Scaled sparse linear regression. Biometrika,
  99(4):879-898.}

   T. Sun and C.-H. Zhang. (2013) \emph{Sparse matrix inversion with scaled
  lasso. The Journal of Machine Learning Research, 14(1):3385-3418.}
}
\seealso{
\code{\link{sqrt_lasso}} and \code{\link{RPtest_single}}.
}
