% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROCsurf.R
\name{ROCsurf}
\alias{ROCsurf}
\alias{dG}
\alias{dW}
\alias{dL}
\alias{pG}
\alias{pW}
\alias{pL}
\alias{qG}
\alias{qW}
\alias{qL}
\alias{rG}
\alias{rW}
\alias{rL}
\alias{r.tc_vus}
\alias{r.tc_index}
\alias{r.tc_graph}
\title{ROC Surface Analysis Under the Three-class Problems}
\usage{
dG(x, alpha, beta)

dW(x, alpha, beta)

dL(z, alpha, beta)

pG(x, alpha, beta)

pW(y, alpha, beta)

pL(y, alpha, beta)

qG(p, alpha, beta)

qW(p, alpha, beta)

qL(p, alpha, beta)

rG(n, alpha, beta)

rW(n, alpha, beta)

rL(n, alpha, beta)

r.tc_vus(
  x,
  y,
  z,
  init_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1, alpha3 = 1, beta3 = 1),
  true_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1, alpha3 = 1, beta3 = 1),
  model = c("GWL", "GGW", "WGW", "WWW", "GGG", "LLL"),
  method = c("MLE", "AD", "CvM", "LSE", "WLSE", "TRUE")
)

r.tc_index(
  x,
  y,
  z,
  init_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1, alpha3 = 1, beta3 = 1),
  true_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1, alpha3 = 1, beta3 = 1),
  init_index = c(x, y),
  model = c("GWL", "GGW", "WGW", "WWW", "GGG", "LLL"),
  method = c("MLE", "AD", "CvM", "LSE", "WLSE", "TRUE")
)

r.tc_graph(
  x,
  y,
  z,
  init_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1, alpha3 = 1, beta3 = 1),
  true_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1, alpha3 = 1, beta3 = 1),
  empirical = TRUE,
  model = c("GWL", "GGW", "WGW", "WWW", "GGG", "LLL"),
  method = c("MLE", "AD", "CvM", "LSE", "WLSE", "TRUE")
)
}
\arguments{
\item{x, y, z}{vector of quantiles.}

\item{alpha}{shape parameter.}

\item{beta}{scale parameter.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}

\item{init_param}{initial paremeter values for the estimation method.}

\item{true_param}{true parameter values.}

\item{model}{selected model. The default value for the model is "GWL".}

\item{method}{estimation method. The default value for the method is "MLE".}

\item{init_index}{initial index value for the optimization calculation.}

\item{empirical}{empirical must be TRUE or FALSE.}

\item{alpha1}{shape parameter of distribution of first sample.}

\item{beta1}{scale parameter of distribution of first sample.}

\item{alpha2}{shape parameter of distribution of second sample.}

\item{beta2}{scale parameter of distribution of second sample.}

\item{alpha3}{location parameter of distribution of third sample.}

\item{beta3}{scale parameter of distribution of third sample.}
}
\value{
\code{dG} gives the probability density function of Gamma
Distribution.

\code{dW} gives the probability density function of Weibull
Distribution.

\code{dL} gives the probability density function of Logistic
Distribution.

\code{pG} gives the cumulative density function of
Gamma Distribution.

\code{pW} gives the cumulative density function of
Weibull Distribution.

\code{pL} gives the cumulative density function of
Logistic Distribution.

\code{qG} gives the quantile function of
Gamma Distribution.

\code{qW} gives the quantile function of
Weibull Distribution.

\code{qL} gives the quantile function of
Logistic Distribution.

\code{rG} gives random numbers from Gamma Distribution.

\code{rW} gives random numbers from Weibull Distribution.

\code{rL} gives random numbers from Logistic Distribution.

\code{r.tc_vus} gives the Volume Under the Surface (VUS) when the
data conforms to the proposed three distributions.

\code{r.tc_index} gives index values when the
data conforms to the proposed three distributions.

\code{r.tc_graph} gives the ROC curve when the data conforms to the
proposed three distributions.
}
\description{
ROC surface analysis is performed under the three-class
classification problems. The volume under the ROC surface and true positive
fractions values are evaulated by ROC surface analysis.
}
\details{
The Gamma, Weibull, and Logistic distributions are widely used in statistical
modeling and analysis. Below are the descriptions of their probability
density functions (PDF), cumulative distribution functions (CDF), and
quantile functions, including their parameter constraints.

\strong{Gamma Distribution}

The Gamma distribution is a continuous probability distribution characterized
by its shape (\eqn{\alpha}) and scale (\eqn{\beta}) parameters. It is
commonly used to model waiting times or lifetimes of objects.
\itemize{
\item \strong{Probability Density Function (PDF)}:
\deqn{f(x; \alpha, \beta) = \frac{1}{\Gamma(\alpha) \beta^\alpha}
  x^{\alpha - 1} \exp\left(-\frac{x}{\beta}\right),{x > 0}}
,where \eqn{\alpha > 0} and \eqn{\beta > 0}.
\item \strong{Cumulative Distribution Function (CDF)}:
\deqn{F(x; \alpha, \beta) = \frac{1}{\Gamma(\alpha)}
  \gamma\left(\alpha, \frac{x}{\beta}\right)}
,where \eqn{\gamma(\alpha, x/\beta)} is the lower incomplete Gamma function.
\item \strong{Quantile Function}:

The quantile function is the inverse of the CDF, denoted as
\eqn{Q(p; \alpha, \beta) = F^{-1}(p; \alpha, \beta)}
,where \eqn{0 < p < 1}.
}

\strong{Weibull Distribution}

The Weibull distribution is used in reliability analysis and failure time
analysis, characterized by its shape (\eqn{\alpha}) and scale (\eqn{\beta})
parameters.
\itemize{
\item \strong{Probability Density Function (PDF)}:
\deqn{f(x; \alpha, \beta) = \frac{\alpha}{\beta}
  \left( \frac{x}{\beta} \right)^{\alpha - 1}
  \exp\left( - \left( \frac{x}{\beta} \right)^\alpha \right), {x \geq 0}}
,where \eqn{\alpha > 0}, and \eqn{\beta > 0}.
\item \strong{Cumulative Distribution Function (CDF)}:
\deqn{F(x; \alpha, \beta) = 1 - \exp\left( - \left( \frac{x}{\beta}
  \right)^\alpha \right)}
,where \eqn{\alpha > 0}, and \eqn{\beta > 0}.
\item \strong{Quantile Function}:
\deqn{Q(p; \alpha, \beta) = \beta \left( -\log(1 - p) \right)^{1/\alpha}}
,where \eqn{0 < p < 1}, \eqn{\alpha > 0}, and \eqn{\beta > 0}.
}

\strong{Logistic Distribution}

The Logistic distribution is used for growth models and logistic regression,
characterized by its location (\eqn{\alpha}) and scale (\eqn{\beta})
parameters.
\itemize{
\item \strong{Probability Density Function (PDF)}:
\deqn{f(x; \alpha, \beta) = \frac{\exp \left( - \frac{x - \alpha}{\beta}
  \right)}{\beta \left( 1 + \exp \left( - \frac{x - \alpha}{\beta} \right)
  \right)^2},{-\infty < x < \infty}}
,where \eqn{\alpha \in \mathbb{R}}, and \eqn{\beta > 0}.
\item \strong{Cumulative Distribution Function (CDF)}:
\deqn{F(x; \alpha, \beta) = \frac{1}{1 +
  \exp \left( - \frac{x - \alpha}{\beta} \right)}}
,where \eqn{\alpha \in \mathbb{R}}, and \eqn{\beta > 0}.
\item \strong{Quantile Function}:
\deqn{Q(p; \alpha, \beta) = \alpha + \beta \log
  \left( \frac{p}{1 - p} \right)}
,where \eqn{0 < p < 1}, \eqn{\alpha \in \mathbb{R}}, and \eqn{\beta > 0}.
}

Additionally, the estimation methods Anderson-Darling "AD", Cramér-von Mises
"CvM", least squares "LS" and weighted least squares "WLS" as well as the
"TRUE" option for the true value, are available. Please note that the default
value for the method parameter is maximum likelihood "ML" estimation. Also,
models such as "GWL," "WWW," and "WGW" are defined for evaluating ROC surface
analysis under three-class classification problems.

The cut-off point values corresponding to the generalized Youden's J index
(J), The Perfection method (PM), The Maximum Volume (MV), and the newly
proposed indices (NI, M) are provided.
}
\examples{
dG(c(1,2,3,4,5,200,1000),alpha=6,beta=.8)
dW(c(1,2,3,4,5,200,10000),alpha=1,beta=2)
dL(c(1,2,3,4,5,200),alpha=1,beta=.1)
pG(c(.5,1,2,3,4,25),alpha=6,beta=.8)
pW(c(.5,1,2,3,4,100),alpha=1,beta=2)
pL(c(.5,1,2),alpha=1,beta=.1)
qG(c(.9971,0.5,0.3),alpha=6,beta=.8)
qW(c(.9971,0.5,0.3),alpha=1,beta=2)
qL(c(.9971,0.5,0.3),alpha=1,beta=.1)
rG(10,alpha=6,beta=.8)
rW(10,alpha=1,beta=2)
rL(10,alpha=1,beta=.1)
x<- rW(100,  2,  1)
y <- rG(100,  2, 2)
z <- rW(100,  6,  9)
r.tc_vus(x=x,y=y,z=z,
        init_param=c(alpha1=2,beta1=1,alpha2=2,beta2=2,
                     alpha3=6,beta3=9),
        model=c("WGW"), method=c("MLE"))
x<- rW(100,  2,  1)
y <- rG(100,  2, 2)
z <- rW(100,  6,  9)
r.tc_index(x=x,y=y,z=z,
          init_param=c(alpha1=2,beta1=1,alpha2=2,
                       beta2=2,alpha3=6,beta3=9),
          init_index=c(median(x),median(y)),
          model=c("WGW"),
          method=c("MLE"))
x<- rW(100,  2,  1)
y <- rG(100,  2, 2)
z <- rW(100,  6,  9)
r.tc_graph(x=x,y=y,z=z,
          init_param=c(alpha1=2,beta1=1,alpha2=2,
                       beta2=2,alpha3=6,beta3=9),
          empirical=FALSE,model=c("WGW"),
          method=c("MLE"))
}
\references{
Akgenç, E., and Kuş, C., 2023,
\emph{Statistical Inference for ROC Surface Analysis Under the Three-Class}
\emph{Problems},
7th International Congress of Researchers, Statisticians and
Young Statisticians (IRSYSC-2023).

B. R. Mosier and L. E. Bantis., 2021,
\emph{Estimation and construction of confidence intervals for biomarker}
\emph{cutoff-points under the shortest euclidean distance from the roc surface to}
\emph{the perfection corner},
Statistics in medicine, 40(20):4522–4539.
\url{doi:10.1002/sim.9077}

G. Jameson., 2016,
\emph{The incomplete gamma functions.},
The Mathematical Gazette, 100(548):298–306.
\url{doi:10.1017/mag.2016.67}

T. Dong., 2014,
\emph{Selected Topics on Statistical Methods for Three and Multiple Class}
\emph{Diagnostic Studies},
State University of New York at Buffalo.

J. Luo and C. Xiong., 2013,
\emph{Youden index and associated cut-points for three ordinal diagnostic groups},
Communications in Statistics-Simulation and Computation, 42(6):1213–1234.
\url{doi:10.1080/03610918.2012.661906}

F. Edition, A. Papoulis, and S. U. Pillai., 2002,
\emph{Pobability, random variables, and stochastic processes},
McGraw-Hill Europe: New York, NY, USA.

A. J. Hallinan Jr., 1993,
\emph{A review of the weibull distribution},
Journal of Quality Technology, 25(2):85–93.
\url{doi:10.1080/00224065.1993.11979431}

N. Balakrishnan., 1991,
\emph{Handbook of the logistic distribution},
CRC Press.
}
