% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROCSI.R
\name{MClogit}
\alias{MClogit}
\title{MClogit}
\usage{
MClogit(
  dataset,
  yvar,
  xvars,
  trtvar,
  cvar = NULL,
  nfolds = 5,
  type = "binary",
  newx = NULL,
  bestsub = "lambda.1se",
  type.measure = "auc"
)
}
\arguments{
\item{dataset}{data matrix for training dataset}

\item{yvar}{column name for outcome}

\item{xvars}{a string vector of column names for input markers}

\item{trtvar}{column name for treatment (the column should contain binary code with 1 being treatment and 0 being control)}

\item{cvar}{column name for censor (the column should contain binary code with 1 being event and 0 being censored)}

\item{nfolds}{n fold CV used for cv.glmnet}

\item{type}{outcome type ("binary" for binary outcome and "survival" for time-to-event outcome)}

\item{newx}{data matrix for testing dataset X}

\item{bestsub}{criteria for best lambda, used by glmnet}

\item{type.measure}{type of measure used by glmnet}
}
\value{
A list with ROCSI output
\describe{
  \item{x.logit}{final beta estimated from MClogit}
  \item{predScore}{a data.frame of testing data and its predictive signature scores (based on beta.aABC) for each subjects}
  \item{abc}{ABC in testing dataset based on optimal beta}
  \item{fit.cv}{the fitted glmnet object}
}
}
\description{
function for modified covariate methods based on glmnet
}
\details{
function for ROCSI
}
\examples{
n <- 100
k <- 5
prevalence <- sqrt(0.5)
rho<-0.2
sig2 <- 2
rhos.bt.real <- c(0, rep(0.1, (k-3)))*sig2
y.sig2 <- 1
yvar="y.binary"
xvars=paste("x", c(1:k), sep="")
trtvar="treatment"
prog.eff <- 0.5
effect.size <- 1
a.constent <- effect.size/(2*(1-prevalence))
ObsData <- data.gen(n=n, k=k, prevalence=prevalence, prog.eff=prog.eff,
                    sig2=sig2, y.sig2=y.sig2, rho=rho,
                    rhos.bt.real=rhos.bt.real, a.constent=a.constent)
TestData <- data.gen(n=n, k=k, prevalence=prevalence, prog.eff=prog.eff,
                     sig2=sig2, y.sig2=y.sig2, rho=rho,
                     rhos.bt.real=rhos.bt.real, a.constent=a.constent)
bst.mod <- MClogit(dataset=ObsData$data, yvar=yvar, xvars=xvars,
trtvar=trtvar, nfolds = 5, newx=TestData$data,
type="binary", bestsub="lambda.1se")
bst.mod$abc
bst.mod$x.logit[-1,1]
}
