% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{plot_chromosome}
\alias{plot_chromosome}
\title{Plot gene expression along a chromosome}
\usage{
plot_chromosome(vsd, chr, scale = FALSE, trunc_val = NULL)
}
\arguments{
\item{vsd}{An object generated by \code{DESeq2::vst()}}

\item{chr}{A string denoting a chromosome as annotated by ENSEMBL, e.g.
'1', '2', 'X', 'Y', 'MT'}

\item{scale}{Whether to scale the columns of the heatmap}

\item{trunc_val}{Truncate the expression matrix to this value prior to plotting. This is useful
if some very high expression values dominate the heatmap. By default, the heatmap is truncated
to expression values at most 3 standard deviations from the mean.}
}
\value{
A Heatmap-class object of the \code{ComplexHeatmap} package that contains the heatmap of expression values.
}
\description{
Plot gene expression along a chromosome
}
\examples{
library("DESeq2")
chr1 <- T47D[which(mcols(T47D)$chromosome=="1"),]
vsd <- vst(chr1)
plot_chromosome(vsd, chr="1")

}
