% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpca_e.R
\name{mlpca_e}
\alias{mlpca_e}
\title{Maximum likelihood principal component analysis for mode E error conditions}
\usage{
mlpca_e(X, Cov, p, MaxIter = 20000)
}
\arguments{
\item{X}{IxJ matrix of measurements}

\item{Cov}{JXJXI matrices of measurement error covariance}

\item{p}{Rank of the model's subspace, p must be than the minimum of I and J}

\item{MaxIter}{Maximum no. of iterations}
}
\value{
The parameters returned are the results of SVD on the estimated
subspace. The quantity Ssq represents the sum of squares of weighted
residuals. ErrFlag indicates the convergence condition,
with 0 indicating normal termination and 1 indicating the maximum number of
iterations have been exceeded.
}
\description{
Performs maximum likelihood principal components analysis for
mode E error conditions (correlated errors, with a different covariance
matrix for each row, but no error correlation between the rows). Employs an
ALS algorithm.
}
\details{
The returned parameters, U, S and V, are analogs to the
truncated SVD solution, but have somewhat different properties since they
represent the MLPCA solution. In particular, the solutions for different
values of p are not necessarily nested (the rank 1 solution may not be in
the space of the rank 2 solution) and the eigenvectors do not necessarily
account for decreasing amounts of variance, since MLPCA is a subspace
modeling technique and not a variance modeling technique.
}
\examples{

\donttest{
library(RMLPCA)
data(data_clean_e)
data(data_error_e)
# covariance matrix
data(cov_e)
data(data_cleaned_mlpca_e)
# data that you will usually have on hands
data_noisy <- data_clean_e + data_error_e

# run mlpca_e with rank p = 1
results <- RMLPCA::mlpca_e(
  X = data_noisy,
  Cov = cov_e,
  p = 1
)

# estimated clean dataset
data_cleaned_mlpca <- results$U \%*\% results$S \%*\% t(results$V)
}
}
\references{
Wentzell, P. D.
"Other topics in soft-modeling: maximum likelihood-based soft-modeling
methods." (2009): 507-558.
}
\author{
Renan Santos Barbosa
}
