% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_nb_iter}
\alias{get_nb_iter}
\alias{get_nb_iter.rdmc_tuned}
\alias{get_nb_iter.rdmc}
\title{Extract the number of iterations}
\usage{
get_nb_iter(object, ...)

\method{get_nb_iter}{rdmc_tuned}(object, ...)

\method{get_nb_iter}{rdmc}(object, ...)
}
\arguments{
\item{object}{an object returned by an iterative matrix completion 
algorithm.}

\item{\dots}{currently ignored.}
}
\value{
The number of iterations performed in the iterative algorithm.
}
\description{
Extract the number of iterations from an object returned by a matrix 
completion algorithm.
}
\examples{
# toy example derived from MovieLens 100K dataset
data("MovieLensToy")
# robust discrete matrix completion with hyperparameter tuning
set.seed(20250723)
fit <- rdmc_tune(MovieLensToy, 
                 lambda = fraction_grid(nb_lambda = 6),
                 splits = holdout_control(R = 5))
# extract number of iterations with optimal regularization parameter
get_nb_iter(fit)

}
\seealso{
\code{\link{rdmc_tune}()}
}
\author{
Andreas Alfons
}
\keyword{utilities}
