% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRMP.R
\name{apply.SRMP}
\alias{apply.SRMP}
\title{Apply SRMP (Simple Ranking Method using Reference Profiles) on data}
\usage{
apply.SRMP(evaluations.mat, reference.profiles, weights)
}
\arguments{
\item{evaluations.mat}{the matrix comparing alternatives based on criteria}

\item{reference.profiles}{matrix containing reference profile information}

\item{weights}{of different criteria}
}
\value{
alternatives ranked using SRMP
}
\description{
Apply SRMP (Simple Ranking Method using Reference Profiles) on data
}
\examples{
evaluations.mat <- matrix(c(41, 46, 43, -2, -4, -5.5, 4, 2, 3), nrow=3)
colnames(evaluations.mat) <- c("S", "L", "J")
rownames(evaluations.mat) <- c("x", "y", "z")
reference.profiles <- matrix(c(42, 45, -5, -3, 2, 4), nrow=2)
colnames(reference.profiles) <- c("S", "L", "J")
rownames(reference.profiles) <- c("p1", "p2")
weights <- c(1/3, 1/3, 1/3)
apply.SRMP(evaluations.mat, reference.profiles, weights)
}
