% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLumModel-package.R
\docType{data}
\name{ExampleData.ModelOutput}
\alias{ExampleData.ModelOutput}
\alias{model.output}
\title{Example data (TL curve) simulated with parameter set from Pagonis 2007}
\format{
A RLum.Analysis object containing one TL curve as RLum.Data.Curve.
}
\source{
\bold{model_LuminescenceSignals()}
}
\description{
Example data (TL curve) simulated with parameter set from Pagonis 2007
}
\note{
This example has only one record (TL). The used sequence was
sequence <- list(IRR = c(temp = 20, dose = 10, DoseRate = 1),
                 TL = c(temp_begin = 20, temp_end = 400, heating_rate = 5))
}
\section{Function version}{
 0.1.1
}

\examples{

data("ExampleData.ModelOutput", envir = environment())

TL_curve <- get_RLum(model.output, recordType = "TL$", drop = FALSE)

##plot TL curve
plot_RLum(TL_curve)

TL_concentrations <- get_RLum(model.output, recordType = "(TL)", drop = FALSE)
plot_RLum(TL_concentrations)


}
\references{
Pagonis, V., Chen, R., Wintle, A.G., 2007: Modelling thermal transfer in optically
stimulated luminescence of quartz. Journal of Physics D: Applied Physics 40, 998-1006.
}
\author{
Johannes Friedrich, University of Bayreuth (Germany)
}
\keyword{datasets}
