% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_rl_scenarios.R
\name{compute_rl_scenarios}
\alias{compute_rl_scenarios}
\title{Compute DLT Probability Scenarios for Reinforcement Learning}
\usage{
compute_rl_scenarios(J, target, epsilon, delta, lower = 0.1, upper = 0.8)
}
\arguments{
\item{J}{A positive integer value. The number of doses.}

\item{target}{A positive numeric value. The target DLT probability.}

\item{epsilon}{A positive numeric value. The acceptable range of target DLT
probabilities is defined as [\code{target} - \code{epsilon}, \code{target} + \code{epsilon}].}

\item{delta}{A positive numeric value. The unacceptable ranges of target DLT
probabilities are defined as [0, \code{target} - \code{delta}] and
[\code{target} + \code{delta}, 1].}

\item{lower}{A positive numeric value. Values lower than \code{lower} are clipped.
Default is 0.1, which is modified from Sect. 2.2 of the original paper.}

\item{upper}{A positive numeric value. Values higher than \code{upper} are clipped.
Default is 0.8.}
}
\value{
A named list of three elements:
- prob: a list of DLT probability scenarios
- MTD: a list of true MTD indices (Note that \code{-1} means "no MTD")
- weight: a vector of weights for each scenario
}
\description{
Compute the scenarios described in Sect. 2.2 of the original paper.
}
\examples{
scenarios <- compute_rl_scenarios(J = 6, target = 0.25, epsilon = 0.04, delta = 0.1)
print(scenarios)

}
