/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.estimation.IGlsArimaMonitor;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.IarimaInitializer;
import ec.tstoolkit.sarima.estimation.SarimaInitializer;
import ec.tstoolkit.sarima.estimation.SarimaMapping;

public class IterativeGlsSarimaMonitor
extends IGlsArimaMonitor<SarimaModel> {
    private final IarimaInitializer m_initializer;
    private boolean m_all;

    public IterativeGlsSarimaMonitor() {
        this.m_initializer = new SarimaInitializer();
        this.m_all = true;
    }

    public IterativeGlsSarimaMonitor(boolean checkAll) {
        this.m_initializer = new SarimaInitializer();
        this.m_all = checkAll;
    }

    public IterativeGlsSarimaMonitor(boolean checkAll, IarimaInitializer initializer) {
        this.m_initializer = initializer;
        this.m_all = checkAll;
    }

    @Override
    public SarimaModel initialize(RegArimaModel<SarimaModel> regs) {
        if (this.m_initializer != null) {
            return this.m_initializer.initialize(regs);
        }
        return null;
    }

    @Override
    public RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs, SarimaModel start) {
        boolean nomapper;
        if (start != null && !start.isStationary()) {
            throw new ArimaException("acgf_err_st");
        }
        boolean bl = nomapper = this.getMapping() == null;
        if (nomapper) {
            this.setMapping(new SarimaMapping(regs.getArima().getSpecification(), this.m_all));
        }
        RegArimaEstimation<SarimaModel> rslt = super.optimize(regs, start);
        SarimaModel sarima = (SarimaModel)rslt.model.getArima();
        if (SarimaMapping.stabilize(sarima)) {
            rslt.model.setArima(sarima);
        }
        if (nomapper) {
            this.setMapping(null);
        }
        return rslt;
    }
}

