% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balanceTest.R
\name{balanceTest}
\alias{balanceTest}
\title{Standardized Differences for Stratified Comparisons}
\usage{
balanceTest(
  fmla,
  data,
  strata = NULL,
  unit.weights,
  stratum.weights = harmonic_times_mean_weight,
  subset,
  include.NA.flags = TRUE,
  covariate.scales = setNames(numeric(0), character(0)),
  post.alignment.transform = NULL,
  inferentials.calculator = HB08,
  p.adjust.method = "holm"
)
}
\arguments{
\item{fmla}{A formula containing an indicator of treatment
assignment on the left hand side and covariates at right.}

\item{data}{A data frame in which \code{fmla} and \code{strata}
are to be evaluated.}

\item{strata}{A list of right-hand-side-only formulas containing
the factor(s) identifying the strata, with \code{NULL} entries
interpreted as no stratification; or a factor with length equal
to the number of rows in data; or a data frame of such
factors. See below for examples.}

\item{unit.weights}{Per-unit weight, or 0 if unit does not meet condition specified by subset argument. If there are clusters, the cluster weight is the sum of unit weights of elements within the cluster.  Within each stratum, unit weights will be normalized to sum to the number of clusters in the stratum.}

\item{stratum.weights}{Function returning non-negative weight for each stratum; see details.}

\item{subset}{Optional: condition or vector specifying a subset of observations to be permitted to have positive unit weights.}

\item{include.NA.flags}{Present item missingness comparisons as well as covariates themselves?}

\item{covariate.scales}{covariate dispersion estimates to use
as denominators of\code{std.diffs} (optional).}

\item{post.alignment.transform}{Optional transformation applied to
covariates just after their stratum means are subtracted off.
Should accept a vector of weights as its second argument.}

\item{inferentials.calculator}{Function; calculates \sQuote{inferential} statistics. (Not currently intended for use by end-users.)}

\item{p.adjust.method}{Method of p-value adjustment for the univariate tests. See the \code{\link{p.adjust}} function for available methods. By default the "holm" method is used.}
}
\value{
An object of class \code{c("balancetest", "xbal", "list")}. Several
  methods are inherited from the "xbal" class returned by
  \code{\link{xBalance}} function.
}
\description{
Covariate balance, with treatment/covariate association tests
}
\details{
Given a grouping variable (treatment assignment, exposure status, etc)
and variables on which to compare the groups, compare averages across groups
and test hypothesis of no selection into groups on the basis of that variable.
The multivariate test is the method of combined differences discussed by
Hansen and Bowers (2008, Statist. Sci.), a variant of Hotelling's T-squared
test; the univariate tests are presented with multiplicity adjustments, the
details of which can be controlled by the user. Clustering, weighting and/or
stratification variables can be provided, and are addressed by the tests.

The function assembles various univariate descriptive statistics
for the groups to be compared: (weighted) means of treatment and
control groups; differences of these (adjusted differences); and
adjusted differences as multiples of a pooled s.d. of the variable
in the treatment and control groups (standard differences). Pooled
s.d.s are calculated with weights but without attention to clustering,
and ordinarily without attention to stratification.  (If the user does
not request unstratified comparisons, overriding the default setting,
then pooled s.d.s are calculated with weights corresponding to the first
stratification for which comparison is requested.  In this case as
in the default setting, the same pooled s.d.s are used for standardization
under each stratification considered. This facilitates comparison of
standard differences across stratification schemes.)  Means
are contrasted separately for each provided stratifying factor and, by
default, for the unstratified comparison, in each case with weights
reflecting a standardization appropriate to the designated (post-)
stratification of the sample.  In the case without stratification
or clustering, the only weighting used to calculate treatment and
control group means is that provided by the user as
\code{unit.weights}; in the absence of such an argument, these
means are unweighted.  When there are strata, within-stratum means
of treatment or of control observations are calculated using
\code{unit.weights}, if provided, and then these are combined
across strata according to a \sQuote{effect of treatment on
treated}-type weighting scheme. (The function's
\code{stratum.weights} argument figures in the function's
inferential calculations but not these descriptive calculations.)
To figure a stratum's effect of treatment on treated weight, the
sum of all \code{unit.weights} associated with treatment or
control group observations within the stratum is multiplied by the
fraction of clusters in that stratum that are associated with the
treatment rather than the control condition.  (Unless this
fraction is 0 or 1, in which case the stratum is downweighted to
0.)

The function also calculates univariate and multivariate inferential
statistics, targeting the hypothesis that assignment was random within strata. These
calculations also pool \code{unit.weights}-weighted, within-stratum group means across strata,
but the default weighting of strata differs from that of the descriptive calculations.
With \code{stratum.weights=harmonic_times_mean_weight} (the default), each stratum
is weighted in proportion to the product of the stratum mean of \code{unit.weights}
and the harmonic mean \eqn{1/[(1/a + 1/b)/2]=2*a*b/(a+b)} of the number of
treated units (a) and control units (b) in the stratum; this weighting is optimal
under certain modeling assumptions (discussed in Kalton 1968 and Hansen and
Bowers 2008, Sections 3.2 and 5).  The multivariate assessment is based on a Mahalanobis-type
distance that combines each of the univariate mean differences while accounting
for correlations among them. It's similar to the Hotelling's T-squared statistic,
except standardized using a permutation covariance.  See Hansen and Bowers (2008).

In contrast to the earlier function \code{xBalance} that it is intended to replace,
\code{balanceTest} accepts only binary assignment variables (for now).

\code{stratum.weights} must be a function of a single argument,
a data frame containing the variables in \code{data} and
additionally \code{Tx.grp}, \code{stratum.code}, and \code{unit.weights},
returning a named numeric vector of non-negative weights identified by stratum.
(For an example, enter \code{getFromNamespace("harmonic", "RItools")}.)
the data  \code{stratum.weights} function.

If the stratifying factor has NAs, these cases are dropped.  On the other
hand, if NAs in a covariate are found then those observations are dropped for descriptive
calculations and "imputed" to the stratum mean of the variable for inferential calculations.
When covariate values are dropped due to missingness, proportions of observations not missing on
that variable are recorded and returned.  The printed output presents non-missing proportions alongside of
the variables themselves, distinguishing the former by placing them at the bottom of the list and enclosing the
variable's name in parentheses.  If a variable shares a missingness pattern with other another variable,
its missingness information may be labeled with the name of the other variable in the output.
}
\note{
Evidence pertaining to the hypothesis that a treatment
  variable is not associated with differences in covariate values
  is assessed by comparing the differences of means, without standardization, to their distributions
  under hypothetical shuffles of the treatment variable, a
  permutation or randomization distribution.  For the unstratified
  comparison, this reference distribution consists of differences
  as the treatment
  assignments of clusters are freely permuted.  For
  stratified comparisons, the reference distributions describes re-randomizations of
  this type performed separately in each stratum. Significance
  assessments are based on large-sample approximations
  to these reference distributions.
}
\examples{
data(nuclearplants)
## No strata
balanceTest(pr ~ date + t1 + t2 + cap + ne + ct + bw + cum.n,
         data=nuclearplants)

## Stratified
## Note use of the `. - cost` to use all columns except `cost`
balanceTest(pr ~ . - cost + strata(pt),
         data=nuclearplants)

##Missing data handling.
testdata <- nuclearplants
testdata$date[testdata$date < 68] <- NA
balanceTest(pr ~ . - cost + strata(pt),
            data = testdata)

## Variable-by-variable Wilcoxon rank sum tests, with an omnibus test
## of multivariate differences on rank scale.
balanceTest(pr ~ date + t1 + t2 + cap + ne + ct + bw + cum.n,
         data = nuclearplants,
	       post.alignment.transform = function(x, weights) rank(x))

## (Note that the post alignment transform is expected to be a function
## accepting a second argument, even if the argument is not used.
## The unit weights vector will be provided as this second argument,
## enabling use of e.g. `post.alignment.transform=Hmisc::wtd.rank`
## to furnish a version of the Wilcoxon test even when there are clusters and/or weights.)

## An experiment where clusters of individuals are assigned to treatment within strata
## assessing balance of cluster level treatment on both cluster
## and individual level baseline attributes
data(ym_long)
## Look at balance on teriles of cluster size as well as other variables
teriles <- quantile(ym_long$n_practice, seq(1/3,1,by=1/3))
teriles <- c(0, teriles)

balanceTest(trt ~ cut(n_practice, teriles)+assessed+hypo+lipid+
            aspirin+strata(assess_strata)+cluster(practice),
            data=ym_long)
}
\references{
Hansen, B.B. and Bowers, J. (2008), ``Covariate
  Balance in Simple, Stratified and Clustered Comparative
  Studies,'' \emph{Statistical Science} \bold{23}.

  Kalton, G. (1968), ``Standardization: A technique to control for
  extraneous variables,'' \emph{Applied Statistics} \bold{17},
  118--136.
}
\seealso{
\code{\link{HB08}}
}
\author{
Ben Hansen and Jake Bowers and Mark Fredrickson
}
\keyword{design}
\keyword{nonparametric}
