% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/quantizeImage.R
\name{quantize_image}
\alias{quantize_image}
\title{Quantize image}
\usage{
quantize_image(image, n, ...)
}
\arguments{
\item{image}{Matrix The image from which the palette will be extracted from. Should
be a 3 (or more) dimensional matrix. The output of a function such as \code{readJPG()}
or \code{readPNG()} are suitable as \code{image}.}

\item{n}{Integer The number of discrete colors to be extracted from the image.}

\item{...}{Pass any of the arguments for \code{image_palette}}
}
\description{
Quantize image into discrete colors using the median cut algorithm
}
\details{
Note: This function is extremely slow for large images.
Takes up to 20 seconds for 500x500 image on a desktop with 2.7GHz processor and 4Gb ram.
}
\examples{
img <- jpeg::readJPEG(system.file("img", "Rlogo.jpg", package="jpeg"))
quant_img <- quantize_image(img, n=3)
display_image(img)
display_image(quant_img)
}
\seealso{
\code{\link{image_palette}}
}

